/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.monitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.log.ClientLogger;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.admin.ConsumeStats;
import org.apache.rocketmq.common.admin.OffsetWrapper;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.Connection;
import org.apache.rocketmq.common.protocol.body.ConsumerConnection;
import org.apache.rocketmq.common.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.common.protocol.topic.OffsetMovedEvent;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.monitor.DefaultMonitorListener;
import org.apache.rocketmq.tools.monitor.DeleteMsgsEvent;
import org.apache.rocketmq.tools.monitor.MonitorConfig;
import org.apache.rocketmq.tools.monitor.MonitorListener;
import org.apache.rocketmq.tools.monitor.UndoneMsgs;
import org.slf4j.Logger;

public class MonitorService {
    private final Logger log = ClientLogger.getLog();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("MonitorService"));
    private final MonitorConfig monitorConfig;
    private final MonitorListener monitorListener;
    private final DefaultMQAdminExt defaultMQAdminExt;
    private final DefaultMQPullConsumer defaultMQPullConsumer = new DefaultMQPullConsumer("TOOLS_CONSUMER");
    private final DefaultMQPushConsumer defaultMQPushConsumer = new DefaultMQPushConsumer("__MONITOR_CONSUMER");

    public MonitorService(MonitorConfig monitorConfig, MonitorListener monitorListener, RPCHook rpcHook) {
        this.monitorConfig = monitorConfig;
        this.monitorListener = monitorListener;
        this.defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        this.defaultMQAdminExt.setInstanceName(this.instanceName());
        this.defaultMQAdminExt.setNamesrvAddr(monitorConfig.getNamesrvAddr());
        this.defaultMQPullConsumer.setInstanceName(this.instanceName());
        this.defaultMQPullConsumer.setNamesrvAddr(monitorConfig.getNamesrvAddr());
        this.defaultMQPushConsumer.setInstanceName(this.instanceName());
        this.defaultMQPushConsumer.setNamesrvAddr(monitorConfig.getNamesrvAddr());
        try {
            this.defaultMQPushConsumer.setConsumeThreadMin(1);
            this.defaultMQPushConsumer.setConsumeThreadMax(1);
            this.defaultMQPushConsumer.subscribe("OFFSET_MOVED_EVENT", "*");
            this.defaultMQPushConsumer.registerMessageListener(new MessageListenerConcurrently(){

                public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                    try {
                        OffsetMovedEvent ome = (OffsetMovedEvent)OffsetMovedEvent.decode((byte[])msgs.get(0).getBody(), OffsetMovedEvent.class);
                        DeleteMsgsEvent deleteMsgsEvent = new DeleteMsgsEvent();
                        deleteMsgsEvent.setOffsetMovedEvent(ome);
                        deleteMsgsEvent.setEventTimestamp(msgs.get(0).getStoreTimestamp());
                        MonitorService.this.monitorListener.reportDeleteMsgsEvent(deleteMsgsEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
            });
        }
        catch (MQClientException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws MQClientException {
        MonitorService.main0(args, null);
    }

    public static void main0(String[] args, RPCHook rpcHook) throws MQClientException {
        final MonitorService monitorService = new MonitorService(new MonitorConfig(), new DefaultMonitorListener(), rpcHook);
        monitorService.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){
            private volatile boolean hasShutdown = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.hasShutdown) {
                        this.hasShutdown = true;
                        monitorService.shutdown();
                    }
                }
            }
        }, "ShutdownHook"));
    }

    private String instanceName() {
        String name = System.currentTimeMillis() + (long)new Random().nextInt() + this.monitorConfig.getNamesrvAddr();
        return "MonitorService_" + name.hashCode();
    }

    public void start() throws MQClientException {
        this.defaultMQPullConsumer.start();
        this.defaultMQAdminExt.start();
        this.defaultMQPushConsumer.start();
        this.startScheduleTask();
    }

    public void shutdown() {
        this.defaultMQPullConsumer.shutdown();
        this.defaultMQAdminExt.shutdown();
        this.defaultMQPushConsumer.shutdown();
    }

    private void startScheduleTask() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    MonitorService.this.doMonitorWork();
                }
                catch (Exception e) {
                    MonitorService.this.log.error("doMonitorWork Exception", (Throwable)e);
                }
            }
        }, 20000L, this.monitorConfig.getRoundInterval(), TimeUnit.MILLISECONDS);
    }

    public void doMonitorWork() throws RemotingException, MQClientException, InterruptedException {
        long beginTime = System.currentTimeMillis();
        this.monitorListener.beginRound();
        TopicList topicList = this.defaultMQAdminExt.fetchAllTopicList();
        for (String topic : topicList.getTopicList()) {
            if (!topic.startsWith("%RETRY%")) continue;
            String consumerGroup = topic.substring("%RETRY%".length());
            try {
                this.reportUndoneMsgs(consumerGroup);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.reportConsumerRunningInfo(consumerGroup);
            }
            catch (Exception e) {}
        }
        this.monitorListener.endRound();
        long spentTimeMills = System.currentTimeMillis() - beginTime;
        this.log.info("Execute one round monitor work, spent timemills: {}", (Object)spentTimeMills);
    }

    private void reportUndoneMsgs(String consumerGroup) {
        ConsumeStats cs = null;
        try {
            cs = this.defaultMQAdminExt.examineConsumeStats(consumerGroup);
        }
        catch (Exception e) {
            return;
        }
        ConsumerConnection cc = null;
        try {
            cc = this.defaultMQAdminExt.examineConsumerConnectionInfo(consumerGroup);
        }
        catch (Exception e) {
            return;
        }
        if (cs != null) {
            HashMap<String, ConsumeStats> csByTopic = new HashMap<String, ConsumeStats>();
            for (Map.Entry next : cs.getOffsetTable().entrySet()) {
                MessageQueue mq = (MessageQueue)next.getKey();
                OffsetWrapper ow = (OffsetWrapper)next.getValue();
                ConsumeStats csTmp = (ConsumeStats)csByTopic.get(mq.getTopic());
                if (null == csTmp) {
                    csTmp = new ConsumeStats();
                    csByTopic.put(mq.getTopic(), csTmp);
                }
                csTmp.getOffsetTable().put(mq, ow);
            }
            for (Map.Entry next : csByTopic.entrySet()) {
                UndoneMsgs undoneMsgs = new UndoneMsgs();
                undoneMsgs.setConsumerGroup(consumerGroup);
                undoneMsgs.setTopic((String)next.getKey());
                this.computeUndoneMsgs(undoneMsgs, (ConsumeStats)next.getValue());
                this.monitorListener.reportUndoneMsgs(undoneMsgs);
                this.reportFailedMsgs(consumerGroup, (String)next.getKey());
            }
        }
    }

    public void reportConsumerRunningInfo(String consumerGroup) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        ConsumerConnection cc = this.defaultMQAdminExt.examineConsumerConnectionInfo(consumerGroup);
        TreeMap<String, ConsumerRunningInfo> infoMap = new TreeMap<String, ConsumerRunningInfo>();
        for (Connection c : cc.getConnectionSet()) {
            String clientId = c.getClientId();
            if (c.getVersion() < MQVersion.Version.V3_1_8_SNAPSHOT.ordinal()) continue;
            try {
                ConsumerRunningInfo info = this.defaultMQAdminExt.getConsumerRunningInfo(consumerGroup, clientId, false);
                infoMap.put(clientId, info);
            }
            catch (Exception e) {}
        }
        if (!infoMap.isEmpty()) {
            this.monitorListener.reportConsumerRunningInfo(infoMap);
        }
    }

    private void computeUndoneMsgs(UndoneMsgs undoneMsgs, ConsumeStats consumeStats) {
        long total = 0L;
        long singleMax = 0L;
        long delayMax = 0L;
        for (Map.Entry next : consumeStats.getOffsetTable().entrySet()) {
            MessageQueue mq = (MessageQueue)next.getKey();
            OffsetWrapper ow = (OffsetWrapper)next.getValue();
            long diff = ow.getBrokerOffset() - ow.getConsumerOffset();
            if (diff > singleMax) {
                singleMax = diff;
            }
            if (diff > 0L) {
                total += diff;
            }
            if (ow.getLastTimestamp() <= 0L) continue;
            try {
                long maxOffset = this.defaultMQPullConsumer.maxOffset(mq);
                if (maxOffset <= 0L) continue;
                PullResult pull = this.defaultMQPullConsumer.pull(mq, "*", maxOffset - 1L, 1);
                switch (pull.getPullStatus()) {
                    case FOUND: {
                        long delay = ((MessageExt)pull.getMsgFoundList().get(0)).getStoreTimestamp() - ow.getLastTimestamp();
                        if (delay <= delayMax) break;
                        delayMax = delay;
                        break;
                    }
                    case NO_MATCHED_MSG: 
                    case NO_NEW_MSG: 
                    case OFFSET_ILLEGAL: {
                        break;
                    }
                }
            }
            catch (Exception e) {}
        }
        undoneMsgs.setUndoneMsgsTotal(total);
        undoneMsgs.setUndoneMsgsSingleMQ(singleMax);
        undoneMsgs.setUndoneMsgsDelayTimeMills(delayMax);
    }

    private void reportFailedMsgs(String consumerGroup, String topic) {
    }
}

