/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.topic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.QueueData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class UpdateTopicPermSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "updateTopicPerm";
    }

    @Override
    public String commandDesc() {
        return "Update topic perm";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("b", "brokerAddr", true, "create topic to which broker");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("c", "clusterName", true, "create topic to which cluster");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "topic name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("p", "perm", true, "set topic's permission(2|4|6), intro[2:W; 4:R; 6:RW]");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            TopicConfig topicConfig = new TopicConfig();
            if (!commandLine.hasOption('t')) {
                System.out.printf("topic paramter value must be need.%n", new Object[0]);
                return;
            }
            String topic = commandLine.getOptionValue('t').trim();
            TopicRouteData topicRouteData = defaultMQAdminExt.examineTopicRouteInfo(topic);
            assert (topicRouteData != null);
            List queueDatas = topicRouteData.getQueueDatas();
            assert (queueDatas != null && queueDatas.size() > 0);
            QueueData queueData = (QueueData)queueDatas.get(0);
            topicConfig.setTopicName(topic);
            topicConfig.setWriteQueueNums(queueData.getWriteQueueNums());
            topicConfig.setReadQueueNums(queueData.getReadQueueNums());
            topicConfig.setTopicSysFlag(queueData.getTopicSynFlag());
            if (!commandLine.hasOption('p')) {
                System.out.printf("perm paramter value must be need.%n", new Object[0]);
                return;
            }
            int perm = Integer.parseInt(commandLine.getOptionValue('p').trim());
            topicConfig.setPerm(perm);
            if (commandLine.hasOption('b')) {
                String brokerAddr = commandLine.getOptionValue('b').trim();
                List brokerDatas = topicRouteData.getBrokerDatas();
                String brokerName = null;
                for (BrokerData data : brokerDatas) {
                    HashMap brokerAddrs = data.getBrokerAddrs();
                    if (brokerAddrs == null || brokerAddrs.size() == 0) continue;
                    for (Map.Entry entry : brokerAddrs.entrySet()) {
                        if (!brokerAddr.equals(entry.getValue()) || 0L != (Long)entry.getKey()) continue;
                        brokerName = data.getBrokerName();
                        break;
                    }
                    if (brokerName == null) continue;
                    break;
                }
                if (brokerName != null) {
                    List queueDataList = topicRouteData.getQueueDatas();
                    assert (queueDataList != null && queueDataList.size() > 0);
                    int oldPerm = 0;
                    for (QueueData data : queueDataList) {
                        if (!brokerName.equals(data.getBrokerName())) continue;
                        oldPerm = data.getPerm();
                        if (perm != oldPerm) break;
                        System.out.printf("new perm equals to the old one!%n", new Object[0]);
                        return;
                    }
                    defaultMQAdminExt.createAndUpdateTopicConfig(brokerAddr, topicConfig);
                    System.out.printf("update topic perm from %s to %s in %s success.%n", oldPerm, perm, brokerAddr);
                    System.out.printf("%s.%n", topicConfig);
                    return;
                }
                System.out.printf("updateTopicPerm error broker not exit or broker is not master!.%n", new Object[0]);
                return;
            }
            if (commandLine.hasOption('c')) {
                String clusterName = commandLine.getOptionValue('c').trim();
                Set<String> masterSet = CommandUtil.fetchMasterAddrByClusterName(defaultMQAdminExt, clusterName);
                for (String addr : masterSet) {
                    defaultMQAdminExt.createAndUpdateTopicConfig(addr, topicConfig);
                    System.out.printf("update topic perm from %s to %s in %s success.%n", queueData.getPerm(), perm, addr);
                }
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

