/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.cluster;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.body.KVTable;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class ClusterListSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "clusterList";
    }

    @Override
    public String commandDesc() {
        return "List all of clusters";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("m", "moreStats", false, "Print more stats");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("i", "interval", true, "specify intervals numbers, it is in seconds");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        long printInterval = 1L;
        boolean enableInterval = commandLine.hasOption('i');
        if (enableInterval) {
            printInterval = Long.parseLong(commandLine.getOptionValue('i')) * 1000L;
        }
        try {
            defaultMQAdminExt.start();
            long i = 0L;
            do {
                if (i++ > 0L) {
                    Thread.sleep(printInterval);
                }
                if (commandLine.hasOption('m')) {
                    this.printClusterMoreStats(defaultMQAdminExt);
                    continue;
                }
                this.printClusterBaseInfo(defaultMQAdminExt);
            } while (enableInterval);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    private void printClusterMoreStats(DefaultMQAdminExt defaultMQAdminExt) throws RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, InterruptedException, MQBrokerException {
        ClusterInfo clusterInfoSerializeWrapper = defaultMQAdminExt.examineBrokerClusterInfo();
        System.out.printf("%-16s  %-32s %14s %14s %14s %14s%n", "#Cluster Name", "#Broker Name", "#InTotalYest", "#OutTotalYest", "#InTotalToday", "#OutTotalToday");
        Iterator itCluster = clusterInfoSerializeWrapper.getClusterAddrTable().entrySet().iterator();
        while (itCluster.hasNext()) {
            Map.Entry next = itCluster.next();
            String clusterName = (String)next.getKey();
            TreeSet brokerNameSet = new TreeSet();
            brokerNameSet.addAll((Collection)next.getValue());
            for (String brokerName : brokerNameSet) {
                BrokerData brokerData = (BrokerData)clusterInfoSerializeWrapper.getBrokerAddrTable().get(brokerName);
                if (brokerData == null) continue;
                for (Map.Entry next1 : brokerData.getBrokerAddrs().entrySet()) {
                    long inTotalYest = 0L;
                    long outTotalYest = 0L;
                    long inTotalToday = 0L;
                    long outTotalToday = 0L;
                    try {
                        KVTable kvTable = defaultMQAdminExt.fetchBrokerRuntimeStats((String)next1.getValue());
                        String msgPutTotalYesterdayMorning = (String)kvTable.getTable().get("msgPutTotalYesterdayMorning");
                        String msgPutTotalTodayMorning = (String)kvTable.getTable().get("msgPutTotalTodayMorning");
                        String msgPutTotalTodayNow = (String)kvTable.getTable().get("msgPutTotalTodayNow");
                        String msgGetTotalYesterdayMorning = (String)kvTable.getTable().get("msgGetTotalYesterdayMorning");
                        String msgGetTotalTodayMorning = (String)kvTable.getTable().get("msgGetTotalTodayMorning");
                        String msgGetTotalTodayNow = (String)kvTable.getTable().get("msgGetTotalTodayNow");
                        inTotalYest = Long.parseLong(msgPutTotalTodayMorning) - Long.parseLong(msgPutTotalYesterdayMorning);
                        outTotalYest = Long.parseLong(msgGetTotalTodayMorning) - Long.parseLong(msgGetTotalYesterdayMorning);
                        inTotalToday = Long.parseLong(msgPutTotalTodayNow) - Long.parseLong(msgPutTotalTodayMorning);
                        outTotalToday = Long.parseLong(msgGetTotalTodayNow) - Long.parseLong(msgGetTotalTodayMorning);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.printf("%-16s  %-32s %14d %14d %14d %14d%n", clusterName, brokerName, inTotalYest, outTotalYest, inTotalToday, outTotalToday);
                }
            }
            if (!itCluster.hasNext()) continue;
            System.out.printf("", new Object[0]);
        }
    }

    private void printClusterBaseInfo(DefaultMQAdminExt defaultMQAdminExt) throws RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, InterruptedException, MQBrokerException {
        ClusterInfo clusterInfoSerializeWrapper = defaultMQAdminExt.examineBrokerClusterInfo();
        System.out.printf("%-16s  %-22s  %-4s  %-22s %-16s %19s %19s %10s %5s %6s%n", "#Cluster Name", "#Broker Name", "#BID", "#Addr", "#Version", "#InTPS(LOAD)", "#OutTPS(LOAD)", "#PCWait(ms)", "#Hour", "#SPACE");
        Iterator itCluster = clusterInfoSerializeWrapper.getClusterAddrTable().entrySet().iterator();
        while (itCluster.hasNext()) {
            Map.Entry next = itCluster.next();
            String clusterName = (String)next.getKey();
            TreeSet brokerNameSet = new TreeSet();
            brokerNameSet.addAll((Collection)next.getValue());
            for (String brokerName : brokerNameSet) {
                BrokerData brokerData = (BrokerData)clusterInfoSerializeWrapper.getBrokerAddrTable().get(brokerName);
                if (brokerData == null) continue;
                for (Map.Entry next1 : brokerData.getBrokerAddrs().entrySet()) {
                    double in = 0.0;
                    double out = 0.0;
                    String version = "";
                    String sendThreadPoolQueueSize = "";
                    String pullThreadPoolQueueSize = "";
                    String sendThreadPoolQueueHeadWaitTimeMills = "";
                    String pullThreadPoolQueueHeadWaitTimeMills = "";
                    String pageCacheLockTimeMills = "";
                    String earliestMessageTimeStamp = "";
                    String commitLogDiskRatio = "";
                    try {
                        KVTable kvTable = defaultMQAdminExt.fetchBrokerRuntimeStats((String)next1.getValue());
                        String putTps = (String)kvTable.getTable().get("putTps");
                        String getTransferedTps = (String)kvTable.getTable().get("getTransferedTps");
                        sendThreadPoolQueueSize = (String)kvTable.getTable().get("sendThreadPoolQueueSize");
                        pullThreadPoolQueueSize = (String)kvTable.getTable().get("pullThreadPoolQueueSize");
                        sendThreadPoolQueueSize = (String)kvTable.getTable().get("sendThreadPoolQueueSize");
                        pullThreadPoolQueueSize = (String)kvTable.getTable().get("pullThreadPoolQueueSize");
                        sendThreadPoolQueueHeadWaitTimeMills = (String)kvTable.getTable().get("sendThreadPoolQueueHeadWaitTimeMills");
                        pullThreadPoolQueueHeadWaitTimeMills = (String)kvTable.getTable().get("pullThreadPoolQueueHeadWaitTimeMills");
                        pageCacheLockTimeMills = (String)kvTable.getTable().get("pageCacheLockTimeMills");
                        earliestMessageTimeStamp = (String)kvTable.getTable().get("earliestMessageTimeStamp");
                        commitLogDiskRatio = (String)kvTable.getTable().get("commitLogDiskRatio");
                        version = (String)kvTable.getTable().get("brokerVersionDesc");
                        String[] tpss = putTps.split(" ");
                        if (tpss.length > 0) {
                            in = Double.parseDouble(tpss[0]);
                        }
                        if ((tpss = getTransferedTps.split(" ")).length > 0) {
                            out = Double.parseDouble(tpss[0]);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    double hour = 0.0;
                    double space = 0.0;
                    if (earliestMessageTimeStamp != null && earliestMessageTimeStamp.length() > 0) {
                        long mills = System.currentTimeMillis() - Long.valueOf(earliestMessageTimeStamp);
                        hour = (double)mills / 1000.0 / 60.0 / 60.0;
                    }
                    if (commitLogDiskRatio != null && commitLogDiskRatio.length() > 0) {
                        space = Double.valueOf(commitLogDiskRatio);
                    }
                    System.out.printf("%-16s  %-22s  %-4s  %-22s %-16s %19s %19s %10s %5s %6s%n", clusterName, brokerName, next1.getKey(), next1.getValue(), version, String.format("%9.2f(%s,%sms)", in, sendThreadPoolQueueSize, sendThreadPoolQueueHeadWaitTimeMills), String.format("%9.2f(%s,%sms)", out, pullThreadPoolQueueSize, pullThreadPoolQueueHeadWaitTimeMills), pageCacheLockTimeMills, String.format("%2.2f", hour), String.format("%.4f", space));
                }
            }
            if (!itCluster.hasNext()) continue;
            System.out.printf("", new Object[0]);
        }
    }
}

