/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.with;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.with.CommonTableExpressionSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.TableSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class WithSegmentBinder {
    public static WithSegment bind(WithSegment segment, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> externalTableBinderContexts) {
        LinkedList<CommonTableExpressionSegment> boundCommonTableExpressions = new LinkedList<CommonTableExpressionSegment>();
        for (CommonTableExpressionSegment each : segment.getCommonTableExpressions()) {
            CommonTableExpressionSegment boundCommonTableExpression = CommonTableExpressionSegmentBinder.bind(each, binderContext, segment.isRecursive());
            boundCommonTableExpressions.add(boundCommonTableExpression);
            if (segment.isRecursive() && each.getAliasName().isPresent()) {
                externalTableBinderContexts.removeAll((Object)new CaseInsensitiveMap.CaseInsensitiveString((String)each.getAliasName().get()));
            }
            WithSegmentBinder.bindWithColumns(each.getColumns(), boundCommonTableExpression);
            each.getAliasName().ifPresent(optional -> externalTableBinderContexts.put((Object)new CaseInsensitiveMap.CaseInsensitiveString(optional), (Object)WithSegmentBinder.createWithTableBinderContext(boundCommonTableExpression)));
        }
        return new WithSegment(segment.getStartIndex(), segment.getStopIndex(), boundCommonTableExpressions);
    }

    private static SimpleTableSegmentBinderContext createWithTableBinderContext(CommonTableExpressionSegment commonTableExpressionSegment) {
        return new SimpleTableSegmentBinderContext(commonTableExpressionSegment.getSubquery().getSelect().getProjections().getProjections());
    }

    private static void bindWithColumns(Collection<ColumnSegment> columns, CommonTableExpressionSegment boundCommonTableExpression) {
        if (columns.isEmpty()) {
            return;
        }
        Map<String, ColumnProjectionSegment> columnProjections = WithSegmentBinder.extractWithSubqueryColumnProjections(boundCommonTableExpression);
        columns.forEach(each -> {
            ColumnProjectionSegment projectionSegment = (ColumnProjectionSegment)columnProjections.get(each.getIdentifier().getValue());
            if (null != projectionSegment) {
                each.setColumnBoundInfo(WithSegmentBinder.createColumnSegmentBoundInfo(each, projectionSegment.getColumn()));
            }
        });
    }

    private static Map<String, ColumnProjectionSegment> extractWithSubqueryColumnProjections(CommonTableExpressionSegment boundCommonTableExpression) {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        Collection projections = boundCommonTableExpression.getSubquery().getSelect().getProjections().getProjections();
        projections.forEach(arg_0 -> WithSegmentBinder.lambda$extractWithSubqueryColumnProjections$2((Map)result, arg_0));
        return result;
    }

    private static void extractWithSubqueryColumnProjections(ProjectionSegment projectionSegment, Map<String, ColumnProjectionSegment> result) {
        if (projectionSegment instanceof ColumnProjectionSegment) {
            result.put(WithSegmentBinder.getColumnName((ColumnProjectionSegment)projectionSegment), (ColumnProjectionSegment)projectionSegment);
        }
        if (projectionSegment instanceof ShorthandProjectionSegment) {
            ((ShorthandProjectionSegment)projectionSegment).getActualProjectionSegments().forEach(eachProjection -> {
                if (eachProjection instanceof ColumnProjectionSegment) {
                    result.put(WithSegmentBinder.getColumnName((ColumnProjectionSegment)eachProjection), (ColumnProjectionSegment)eachProjection);
                }
            });
        }
    }

    private static String getColumnName(ColumnProjectionSegment columnProjection) {
        return columnProjection.getAliasName().orElse(columnProjection.getColumn().getIdentifier().getValue());
    }

    private static ColumnSegmentBoundInfo createColumnSegmentBoundInfo(ColumnSegment segment, ColumnSegment inputColumnSegment) {
        IdentifierValue originalDatabase = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundInfo().getOriginalDatabase();
        IdentifierValue originalSchema = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundInfo().getOriginalSchema();
        IdentifierValue segmentOriginalTable = segment.getColumnBoundInfo().getOriginalTable();
        IdentifierValue originalTable = Strings.isNullOrEmpty((String)segmentOriginalTable.getValue()) ? Optional.ofNullable(inputColumnSegment).map(optional -> optional.getColumnBoundInfo().getOriginalTable()).orElse(segmentOriginalTable) : segmentOriginalTable;
        IdentifierValue segmentOriginalColumn = segment.getColumnBoundInfo().getOriginalColumn();
        IdentifierValue originalColumn = Optional.ofNullable(inputColumnSegment).map(optional -> optional.getColumnBoundInfo().getOriginalColumn()).orElse(segmentOriginalColumn);
        return new ColumnSegmentBoundInfo(new TableSegmentBoundInfo(originalDatabase, originalSchema), originalTable, originalColumn);
    }

    @Generated
    private WithSegmentBinder() {
    }

    private static /* synthetic */ void lambda$extractWithSubqueryColumnProjections$2(Map result, ProjectionSegment each) {
        WithSegmentBinder.extractWithSubqueryColumnProjections(each, result);
    }
}

