/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.exception;

import com.google.common.base.Preconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.sqlstate.SQLState;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.kernel.category.ConnectionSQLException;

public abstract class DriverConnectionException
extends ConnectionSQLException {
    private static final long serialVersionUID = -4543547821709772632L;
    private static final int DRIVER_CODE = 2;

    protected DriverConnectionException(SQLState sqlState, int errorCode, String reason, Object ... messageArgs) {
        super(sqlState, DriverConnectionException.getErrorCode(errorCode), reason, messageArgs);
    }

    protected DriverConnectionException(SQLState sqlState, int errorCode, Exception cause, String reason, Object ... messageArgs) {
        super(sqlState, DriverConnectionException.getErrorCode(errorCode), cause, reason, messageArgs);
    }

    private static int getErrorCode(int errorCode) {
        Preconditions.checkArgument((errorCode >= 0 && errorCode < 100 ? 1 : 0) != 0, (Object)"The value range of error code should be [0, 100).");
        return 200 + errorCode;
    }
}

