/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngineFactory;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngineFactory;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidator;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidatorFactory;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SafeNumberOperationUtils;

public final class ShardingSQLRouter
implements SQLRouter<ShardingRule> {
    public RouteContext createRouteContext(LogicSQL logicSQL, ShardingSphereSchema schema, ShardingRule rule, ConfigurationProperties props) {
        RouteContext result = new RouteContext();
        SQLStatement sqlStatement = logicSQL.getSqlStatementContext().getSqlStatement();
        Optional<ShardingStatementValidator> validator = ShardingStatementValidatorFactory.newInstance(sqlStatement);
        validator.ifPresent(v -> v.preValidate(rule, logicSQL.getSqlStatementContext(), logicSQL.getParameters(), schema.getMetaData()));
        ShardingConditions shardingConditions = this.createShardingConditions(logicSQL, schema, rule);
        boolean needMergeShardingValues = this.isNeedMergeShardingValues(logicSQL.getSqlStatementContext(), rule);
        if (sqlStatement instanceof DMLStatement && needMergeShardingValues) {
            this.checkSubqueryShardingValues(logicSQL.getSqlStatementContext(), rule, shardingConditions);
            this.mergeShardingConditions(shardingConditions);
        }
        ShardingRouteEngineFactory.newInstance(rule, schema.getMetaData(), logicSQL.getSqlStatementContext(), shardingConditions, props).route(result, rule);
        validator.ifPresent(v -> v.postValidate(sqlStatement, result));
        return result;
    }

    private ShardingConditions createShardingConditions(LogicSQL logicSQL, ShardingSphereSchema schema, ShardingRule rule) {
        List<ShardingCondition> shardingConditions;
        if (logicSQL.getSqlStatementContext().getSqlStatement() instanceof DMLStatement) {
            ShardingConditionEngine<?> shardingConditionEngine = ShardingConditionEngineFactory.createShardingConditionEngine(logicSQL, schema, rule);
            shardingConditions = shardingConditionEngine.createShardingConditions(logicSQL.getSqlStatementContext(), logicSQL.getParameters());
        } else {
            shardingConditions = Collections.emptyList();
        }
        return new ShardingConditions(shardingConditions);
    }

    private boolean isNeedMergeShardingValues(SQLStatementContext<?> sqlStatementContext, ShardingRule rule) {
        boolean selectContainsSubquery = sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).isContainsSubquery();
        boolean insertSelectContainsSubquery = sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext() && ((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext().isContainsSubquery();
        return (selectContainsSubquery || insertSelectContainsSubquery) && !rule.getShardingLogicTableNames(sqlStatementContext.getTablesContext().getTableNames()).isEmpty();
    }

    private void checkSubqueryShardingValues(SQLStatementContext<?> sqlStatementContext, ShardingRule shardingRule, ShardingConditions shardingConditions) {
        for (String each : sqlStatementContext.getTablesContext().getTableNames()) {
            Optional tableRule = shardingRule.findTableRule(each);
            if (!tableRule.isPresent() || !this.isRoutingByHint(shardingRule, (TableRule)tableRule.get()) || HintManager.getDatabaseShardingValues((String)each).isEmpty() || HintManager.getTableShardingValues((String)each).isEmpty()) continue;
            return;
        }
        Preconditions.checkState((!shardingConditions.getConditions().isEmpty() ? 1 : 0) != 0, (Object)"Must have sharding column with subquery.");
        if (shardingConditions.getConditions().size() > 1) {
            Preconditions.checkState((boolean)this.isSameShardingCondition(shardingRule, shardingConditions), (Object)"Sharding value must same with subquery.");
        }
    }

    private boolean isRoutingByHint(ShardingRule shardingRule, TableRule tableRule) {
        return shardingRule.getDatabaseShardingStrategyConfiguration(tableRule) instanceof HintShardingStrategyConfiguration && shardingRule.getTableShardingStrategyConfiguration(tableRule) instanceof HintShardingStrategyConfiguration;
    }

    private boolean isSameShardingCondition(ShardingRule shardingRule, ShardingConditions shardingConditions) {
        ShardingCondition example = shardingConditions.getConditions().remove(shardingConditions.getConditions().size() - 1);
        for (ShardingCondition each : shardingConditions.getConditions()) {
            if (this.isSameShardingCondition(shardingRule, example, each)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameShardingCondition(ShardingRule shardingRule, ShardingCondition shardingCondition1, ShardingCondition shardingCondition2) {
        if (shardingCondition1.getValues().size() != shardingCondition2.getValues().size()) {
            return false;
        }
        for (int i = 0; i < shardingCondition1.getValues().size(); ++i) {
            ShardingConditionValue shardingConditionValue2;
            ShardingConditionValue shardingConditionValue1 = shardingCondition1.getValues().get(i);
            if (this.isSameShardingConditionValue(shardingRule, (ListShardingConditionValue)shardingConditionValue1, (ListShardingConditionValue)(shardingConditionValue2 = shardingCondition2.getValues().get(i)))) continue;
            return false;
        }
        return true;
    }

    private boolean isSameShardingConditionValue(ShardingRule shardingRule, ListShardingConditionValue shardingConditionValue1, ListShardingConditionValue shardingConditionValue2) {
        return this.isSameLogicTable(shardingRule, shardingConditionValue1, shardingConditionValue2) && shardingConditionValue1.getColumnName().equals(shardingConditionValue2.getColumnName()) && SafeNumberOperationUtils.safeEquals(shardingConditionValue1.getValues(), shardingConditionValue2.getValues());
    }

    private boolean isSameLogicTable(ShardingRule shardingRule, ListShardingConditionValue shardingValue1, ListShardingConditionValue shardingValue2) {
        return shardingValue1.getTableName().equals(shardingValue2.getTableName()) || this.isBindingTable(shardingRule, shardingValue1, shardingValue2);
    }

    private boolean isBindingTable(ShardingRule shardingRule, ListShardingConditionValue shardingValue1, ListShardingConditionValue shardingValue2) {
        Optional bindingRule = shardingRule.findBindingTableRule(shardingValue1.getTableName());
        return bindingRule.isPresent() && ((BindingTableRule)bindingRule.get()).hasLogicTable(shardingValue2.getTableName());
    }

    private void mergeShardingConditions(ShardingConditions shardingConditions) {
        if (shardingConditions.getConditions().size() > 1) {
            ShardingCondition shardingCondition = shardingConditions.getConditions().remove(shardingConditions.getConditions().size() - 1);
            shardingConditions.getConditions().clear();
            shardingConditions.getConditions().add(shardingCondition);
        }
    }

    public void decorateRouteContext(RouteContext routeContext, LogicSQL logicSQL, ShardingSphereSchema schema, ShardingRule rule, ConfigurationProperties props) {
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

