/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.engine.impl;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.sharding.route.engine.condition.AlwaysFalseShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.engine.ShardingConditionEngine;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGeneratorFactory;
import org.apache.shardingsphere.sharding.route.engine.condition.value.AlwaysFalseShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionBuilder;
import org.apache.shardingsphere.sql.parser.sql.common.util.SafeNumberOperationUtils;
import org.apache.shardingsphere.sql.parser.sql.common.util.WhereSegmentExtractUtils;

public final class WhereClauseShardingConditionEngine
implements ShardingConditionEngine<SQLStatementContext<?>> {
    private final ShardingRule shardingRule;
    private final PhysicalSchemaMetaData schemaMetaData;

    @Override
    public List<ShardingCondition> createShardingConditions(SQLStatementContext<?> sqlStatementContext, List<Object> parameters) {
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Collections.emptyList();
        }
        ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>();
        ((WhereAvailable)sqlStatementContext).getWhere().ifPresent(segment -> result.addAll(this.createShardingConditions(sqlStatementContext, segment.getExpr(), parameters)));
        List<WhereSegment> subqueryWhereSegments = sqlStatementContext.getSqlStatement() instanceof SelectStatement ? WhereSegmentExtractUtils.getSubqueryWhereSegments((SelectStatement)((SelectStatement)sqlStatementContext.getSqlStatement())) : Collections.emptyList();
        for (WhereSegment each : subqueryWhereSegments) {
            Collection<ShardingCondition> subqueryShardingConditions = this.createShardingConditions(sqlStatementContext, each.getExpr(), parameters);
            if (result.containsAll(subqueryShardingConditions)) continue;
            result.addAll(subqueryShardingConditions);
        }
        return result;
    }

    private Collection<ShardingCondition> createShardingConditions(SQLStatementContext<?> sqlStatementContext, ExpressionSegment expressionSegment, List<Object> parameters) {
        LinkedList<ShardingCondition> result = new LinkedList<ShardingCondition>();
        for (AndPredicate each : new ExpressionBuilder(expressionSegment).extractAndPredicates().getAndPredicates()) {
            Map<Column, Collection<ShardingConditionValue>> shardingConditionValues = this.createShardingConditionValueMap(sqlStatementContext, each, parameters);
            if (shardingConditionValues.isEmpty()) {
                return Collections.emptyList();
            }
            result.add(this.createShardingCondition(shardingConditionValues));
        }
        return result;
    }

    private Map<Column, Collection<ShardingConditionValue>> createShardingConditionValueMap(SQLStatementContext<?> sqlStatementContext, AndPredicate andPredicate, List<Object> parameters) {
        HashMap<Column, Collection<ShardingConditionValue>> result = new HashMap<Column, Collection<ShardingConditionValue>>(andPredicate.getPredicates().size(), 1.0f);
        for (ExpressionSegment each : andPredicate.getPredicates()) {
            Column column;
            Optional<ShardingConditionValue> shardingConditionValue;
            Optional tableName;
            Optional columnSegment = ColumnExtractor.extract((ExpressionSegment)each);
            if (!columnSegment.isPresent() || !(tableName = sqlStatementContext.getTablesContext().findTableName((ColumnSegment)columnSegment.get(), this.schemaMetaData)).isPresent() || !this.shardingRule.isShardingColumn(((ColumnSegment)columnSegment.get()).getIdentifier().getValue(), (String)tableName.get()) || !(shardingConditionValue = ConditionValueGeneratorFactory.generate(each, column = new Column(((ColumnSegment)columnSegment.get()).getIdentifier().getValue(), (String)tableName.get()), parameters)).isPresent()) continue;
            if (!result.containsKey(column)) {
                LinkedList<ShardingConditionValue> shardingConditionValues = new LinkedList<ShardingConditionValue>();
                shardingConditionValues.add(shardingConditionValue.get());
                result.put(column, shardingConditionValues);
                continue;
            }
            ((Collection)result.get(column)).add(shardingConditionValue.get());
        }
        return result;
    }

    private ShardingCondition createShardingCondition(Map<Column, Collection<ShardingConditionValue>> shardingConditionValues) {
        ShardingCondition result = new ShardingCondition();
        for (Map.Entry<Column, Collection<ShardingConditionValue>> entry : shardingConditionValues.entrySet()) {
            try {
                ShardingConditionValue shardingConditionValue = this.mergeShardingConditionValues(entry.getKey(), entry.getValue());
                if (shardingConditionValue instanceof AlwaysFalseShardingConditionValue) {
                    return new AlwaysFalseShardingCondition();
                }
                result.getValues().add(shardingConditionValue);
            }
            catch (ClassCastException ex) {
                throw new ShardingSphereException("Found different types for sharding value `%s`.", new Object[]{entry.getKey()});
            }
        }
        return result;
    }

    private ShardingConditionValue mergeShardingConditionValues(Column column, Collection<ShardingConditionValue> shardingConditionValues) {
        Collection<Comparable<?>> listValue = null;
        Range<Comparable<?>> rangeValue = null;
        for (ShardingConditionValue each : shardingConditionValues) {
            if (each instanceof ListShardingConditionValue) {
                listValue = this.mergeListShardingValues(((ListShardingConditionValue)each).getValues(), listValue);
                if (!listValue.isEmpty()) continue;
                return new AlwaysFalseShardingConditionValue();
            }
            if (!(each instanceof RangeShardingConditionValue)) continue;
            try {
                rangeValue = this.mergeRangeShardingValues(((RangeShardingConditionValue)each).getValueRange(), rangeValue);
            }
            catch (IllegalArgumentException ex) {
                return new AlwaysFalseShardingConditionValue();
            }
        }
        if (null == listValue) {
            return new RangeShardingConditionValue(column.getName(), column.getTableName(), rangeValue);
        }
        if (null == rangeValue) {
            return new ListShardingConditionValue(column.getName(), column.getTableName(), listValue);
        }
        return (listValue = this.mergeListAndRangeShardingValues(listValue, rangeValue)).isEmpty() ? new AlwaysFalseShardingConditionValue() : new ListShardingConditionValue(column.getName(), column.getTableName(), listValue);
    }

    private Collection<Comparable<?>> mergeListShardingValues(Collection<Comparable<?>> value1, Collection<Comparable<?>> value2) {
        if (null == value2) {
            return value1;
        }
        value1.retainAll(value2);
        return value1;
    }

    private Range<Comparable<?>> mergeRangeShardingValues(Range<Comparable<?>> value1, Range<Comparable<?>> value2) {
        return null == value2 ? value1 : SafeNumberOperationUtils.safeIntersection(value1, value2);
    }

    private Collection<Comparable<?>> mergeListAndRangeShardingValues(Collection<Comparable<?>> listValue, Range<Comparable<?>> rangeValue) {
        LinkedList result = new LinkedList();
        for (Comparable<?> each : listValue) {
            if (!SafeNumberOperationUtils.safeContains(rangeValue, each)) continue;
            result.add(each);
        }
        return result;
    }

    @Generated
    public WhereClauseShardingConditionEngine(ShardingRule shardingRule, PhysicalSchemaMetaData schemaMetaData) {
        this.shardingRule = shardingRule;
        this.schemaMetaData = schemaMetaData;
    }
}

