/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.generator.impl;

import com.google.common.collect.Range;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.datetime.DatetimeService;
import org.apache.shardingsphere.infra.spi.required.RequiredSPIRegistry;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ExpressionConditionUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGenerator;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.util.SafeNumberOperationUtils;

public final class ConditionValueBetweenOperatorGenerator
implements ConditionValueGenerator<BetweenExpression> {
    @Override
    public Optional<ShardingConditionValue> generate(BetweenExpression predicate, Column column, List<Object> parameters) {
        Optional<Comparable<?>> betweenConditionValue = new ConditionValue(predicate.getBetweenExpr(), parameters).getValue();
        Optional<Comparable<?>> andConditionValue = new ConditionValue(predicate.getAndExpr(), parameters).getValue();
        if (betweenConditionValue.isPresent() && andConditionValue.isPresent()) {
            return Optional.of(new RangeShardingConditionValue(column.getName(), column.getTableName(), SafeNumberOperationUtils.safeClosed(betweenConditionValue.get(), andConditionValue.get())));
        }
        Date datetime = ((DatetimeService)RequiredSPIRegistry.getRegisteredService(DatetimeService.class)).getDatetime();
        if (!betweenConditionValue.isPresent() && ExpressionConditionUtils.isNowExpression(predicate.getBetweenExpr())) {
            betweenConditionValue = Optional.of(datetime);
        }
        if (!andConditionValue.isPresent() && ExpressionConditionUtils.isNowExpression(predicate.getAndExpr())) {
            andConditionValue = Optional.of(datetime);
        }
        return betweenConditionValue.isPresent() && andConditionValue.isPresent() ? Optional.of(new RangeShardingConditionValue(column.getName(), column.getTableName(), Range.closed(betweenConditionValue.get(), andConditionValue.get()))) : Optional.empty();
    }
}

