/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.CreateFunctionStatementHandler;

public final class ShardingCreateFunctionStatementValidator
extends ShardingDDLStatementValidator<CreateFunctionStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<CreateFunctionStatement> sqlStatementContext, List<Object> parameters, ShardingSphereMetaData metaData) {
        Optional routineBodySegment = CreateFunctionStatementHandler.getRoutineBodySegment((CreateFunctionStatement)((CreateFunctionStatement)sqlStatementContext.getSqlStatement()));
        routineBodySegment.ifPresent(routineBody -> {
            TableExtractor extractor = new TableExtractor();
            Collection existTables = extractor.extractExistTableFromRoutineBody(routineBody);
            this.validateShardingTable(metaData, existTables);
            this.validateTableExist(metaData, existTables);
            this.validateTableNotExist(metaData, extractor.extractNotExistTableFromRoutineBody(routineBody));
        });
    }

    @Override
    public void postValidate(CreateFunctionStatement sqlStatement, RouteContext routeContext) {
    }
}

