/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.function.mysql.impl;

import java.math.BigInteger;
import lombok.Generated;
import org.apache.calcite.util.BitString;
import org.apache.commons.lang3.StringUtils;

public final class MySQLBitCountFunction {
    public static Object bitCount(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof byte[]) {
            return MySQLBitCountFunction.bitCount((byte[])value);
        }
        if (value instanceof String) {
            return StringUtils.isNumeric((CharSequence)((String)value)) ? Long.bitCount(Long.parseLong((String)value)) : 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).bitCount();
        }
        if (value instanceof Integer) {
            return Integer.bitCount((Integer)value);
        }
        if (value instanceof Long) {
            return Long.bitCount((Long)value);
        }
        return 0;
    }

    private static long bitCount(byte[] byteValue) {
        long result = 0L;
        for (char each : BitString.createFromBytes((byte[])byteValue).toBitString().toCharArray()) {
            if ('1' != each) continue;
            ++result;
        }
        return result;
    }

    @Generated
    private MySQLBitCountFunction() {
    }
}

