// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_dnn;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;

import static org.bytedeco.opencv.global.opencv_dnn.*;


    /** \brief Processing params of image to blob.
     *
     * It includes all possible image processing operations and corresponding parameters.
     *
     * @see blobFromImageWithParams
     *
     * \note
     * The order and usage of {@code scalefactor} and {@code mean} are (input - mean) * scalefactor.
     * The order and usage of {@code scalefactor}, {@code size}, {@code mean}, {@code swapRB}, and {@code ddepth} are consistent
     * with the function of \ref blobFromImage.
    */
    @Namespace("cv::dnn") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_dnn.class)
public class Image2BlobParams extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Image2BlobParams(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Image2BlobParams(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Image2BlobParams position(long position) {
            return (Image2BlobParams)super.position(position);
        }
        @Override public Image2BlobParams getPointer(long i) {
            return new Image2BlobParams((Pointer)this).offsetAddress(i);
        }
    
        public Image2BlobParams() { super((Pointer)null); allocate(); }
        private native void allocate();
        public Image2BlobParams(@Const @ByRef Scalar scalefactor, @Const @ByRef(nullValue = "cv::Size()") Size size, @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean,
                                    @Cast("bool") boolean swapRB/*=false*/, int ddepth/*=CV_32F*/, @Cast("cv::dnn::DataLayout") int datalayout/*=cv::dnn::DNN_LAYOUT_NCHW*/,
                                    @Cast("cv::dnn::ImagePaddingMode") int mode/*=cv::dnn::DNN_PMODE_NULL*/, @ByVal(nullValue = "cv::Scalar(0.0)") Scalar borderValue) { super((Pointer)null); allocate(scalefactor, size, mean, swapRB, ddepth, datalayout, mode, borderValue); }
        private native void allocate(@Const @ByRef Scalar scalefactor, @Const @ByRef(nullValue = "cv::Size()") Size size, @Const @ByRef(nullValue = "cv::Scalar()") Scalar mean,
                                    @Cast("bool") boolean swapRB/*=false*/, int ddepth/*=CV_32F*/, @Cast("cv::dnn::DataLayout") int datalayout/*=cv::dnn::DNN_LAYOUT_NCHW*/,
                                    @Cast("cv::dnn::ImagePaddingMode") int mode/*=cv::dnn::DNN_PMODE_NULL*/, @ByVal(nullValue = "cv::Scalar(0.0)") Scalar borderValue);
        public Image2BlobParams(@Const @ByRef Scalar scalefactor) { super((Pointer)null); allocate(scalefactor); }
        private native void allocate(@Const @ByRef Scalar scalefactor);

        /** scalefactor multiplier for input image values. */
        public native @ByRef Scalar scalefactor(); public native Image2BlobParams scalefactor(Scalar setter);
        /** Spatial size for output image. */
        public native @ByRef Size size(); public native Image2BlobParams size(Size setter);
        /** Scalar with mean values which are subtracted from channels. */
        public native @ByRef Scalar mean(); public native Image2BlobParams mean(Scalar setter);
        /** Flag which indicates that swap first and last channels */
        public native @Cast("bool") boolean swapRB(); public native Image2BlobParams swapRB(boolean setter);
        /** Depth of output blob. Choose CV_32F or CV_8U. */
        public native int ddepth(); public native Image2BlobParams ddepth(int setter);
        /** Order of output dimensions. Choose DNN_LAYOUT_NCHW or DNN_LAYOUT_NHWC. */
        public native @Cast("cv::dnn::DataLayout") int datalayout(); public native Image2BlobParams datalayout(int setter);
        /** Image padding mode. @see ImagePaddingMode. */
        public native @Cast("cv::dnn::ImagePaddingMode") int paddingmode(); public native Image2BlobParams paddingmode(int setter);
        /** Value used in padding mode for padding. */
        public native @ByRef Scalar borderValue(); public native Image2BlobParams borderValue(Scalar setter);

        /** \brief Get rectangle coordinates in original image system from rectangle in blob coordinates.
         *  @param rBlob rect in blob coordinates.
         *  @param size original input image size.
         *  @return rectangle in original image coordinates.
         */
        public native @ByVal Rect blobRectToImageRect(@Const @ByRef Rect rBlob, @Const @ByRef Size size);

        /** \brief Get rectangle coordinates in original image system from rectangle in blob coordinates.
         *  @param rBlob rect in blob coordinates.
         *  @param rImg result rect in image coordinates.
         *  @param size original input image size.
         */
        public native void blobRectsToImageRects(@Const @ByRef RectVector rBlob, @ByRef RectVector rImg, @Const @ByRef Size size);
    }
