/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.gmavenplus.mojo.AbstractGroovySourcesMojo;

public abstract class AbstractGroovyStubSourcesMojo
extends AbstractGroovySourcesMojo {
    protected static void removeSourceRoot(MavenProject project, String scopeToRemove, File sourceDirectory) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, IllegalAccessException {
        Class<?> sourceRoot = project.getClass().getClassLoader().loadClass("org.apache.maven.api.SourceRoot");
        Path path = project.getBasedir().toPath().resolve(sourceDirectory.getAbsolutePath()).normalize();
        Field field = project.getClass().getDeclaredField("sources");
        field.setAccessible(true);
        Method scope = sourceRoot.getMethod("scope", new Class[0]);
        Method language = sourceRoot.getMethod("language", new Class[0]);
        Method directory = sourceRoot.getMethod("directory", new Class[0]);
        Method id = project.getClass().getClassLoader().loadClass("org.apache.maven.api.ExtensibleEnum").getMethod("id", new Class[0]);
        Collection sources = (Collection)field.get(project);
        sources.removeIf(source -> {
            try {
                return Objects.equals(id.invoke(scope.invoke(source, new Object[0]), new Object[0]), scopeToRemove) && Objects.equals(id.invoke(language.invoke(source, new Object[0]), new Object[0]), "java") && Objects.equals(directory.invoke(source, new Object[0]), path);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    protected Set<File> getStubs(File outputDirectory) {
        HashSet<File> files = new HashSet<File>();
        FileSetManager fileSetManager = new FileSetManager();
        FileSet fileSet = new FileSet();
        fileSet.setDirectory(outputDirectory.getAbsolutePath());
        fileSet.setIncludes(Collections.singletonList(JAVA_SOURCES_PATTERN));
        for (String file : fileSetManager.getIncludedFiles(fileSet)) {
            files.add(new File(outputDirectory, file));
        }
        return files;
    }
}

