/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;

public class GenericsType
extends ASTNode {
    private ClassNode[] upperBounds;
    private ClassNode lowerBound;
    private ClassNode type;
    private String name;
    private boolean placeholder;
    private boolean resolved;
    private boolean wildcard;

    public GenericsType(ClassNode type, ClassNode[] upperBounds, ClassNode lowerBound) {
        this.type = type;
        this.name = type.getName();
        this.upperBounds = upperBounds;
        this.lowerBound = lowerBound;
        this.placeholder = false;
        this.resolved = false;
    }

    public GenericsType(ClassNode basicType) {
        this(basicType, null, null);
    }

    public ClassNode getType() {
        return this.type;
    }

    public void setType(ClassNode type) {
        this.type = type;
    }

    public String toString() {
        String ret = this.name;
        if (this.upperBounds != null) {
            ret = ret + " extends ";
            for (int i = 0; i < this.upperBounds.length; ++i) {
                ret = ret + this.upperBounds[i].toString();
                if (i + 1 >= this.upperBounds.length) continue;
                ret = ret + " & ";
            }
        } else if (this.lowerBound != null) {
            ret = ret + " super " + this.lowerBound;
        }
        return ret;
    }

    public ClassNode[] getUpperBounds() {
        return this.upperBounds;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
    }

    public boolean isResolved() {
        return this.resolved || this.placeholder;
    }

    public void setResolved(boolean res) {
        this.resolved = res;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public ClassNode getLowerBound() {
        return this.lowerBound;
    }
}

