/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.javac;

import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;

public class JavaStubGenerator {
    private File outputPath;
    private ArrayList toCompile = new ArrayList();
    private ResolveVisitor resolver;

    public JavaStubGenerator(JavaAwareCompilationUnit cu, File outputPath) {
        this.outputPath = outputPath;
    }

    private void mkdirs(File parent, String relativeFile) {
        int index = relativeFile.lastIndexOf(47);
        if (index == -1) {
            return;
        }
        File dir = new File(parent, relativeFile.substring(0, index));
        dir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateClass(ClassNode classNode) throws FileNotFoundException {
        String fileName = classNode.getName().replace('.', '/');
        this.mkdirs(this.outputPath, fileName);
        this.toCompile.add(fileName);
        File file = new File(this.outputPath, fileName + ".java");
        FileOutputStream fos = new FileOutputStream(file);
        PrintWriter out = new PrintWriter(fos);
        try {
            String packageName = classNode.getPackageName();
            if (packageName != null) {
                out.println("package " + packageName + ";\n");
            }
            this.genImports(classNode, out);
            boolean isInterface = classNode.isInterface();
            this.printModifiers(out, classNode.getModifiers() & ~(isInterface ? 1024 : 0));
            out.println((isInterface ? "interface " : "class ") + classNode.getNameWithoutPackage());
            ClassNode superClass = classNode.getSuperClass();
            if (!isInterface) {
                if (superClass.equals(ClassHelper.OBJECT_TYPE)) {
                    superClass = ClassHelper.make(GroovyObjectSupport.class);
                }
                out.println("  extends " + superClass.getName());
            } else if (!superClass.equals(ClassHelper.OBJECT_TYPE)) {
                out.println("  extends " + superClass.getName());
            }
            ClassNode[] interfaces = classNode.getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                out.println("  implements");
                for (int i = 0; i < interfaces.length - 1; ++i) {
                    out.println("    " + interfaces[i].getName() + ",");
                }
                out.println("    " + interfaces[interfaces.length - 1].getName());
            }
            out.println("{");
            this.genMethods(classNode, out);
            this.genFields(classNode, out);
            this.genProps(classNode, out);
            out.println("}");
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {}
            try {
                fos.close();
            }
            catch (IOException e) {}
        }
    }

    private void genMethods(ClassNode classNode, PrintWriter out) {
        this.getContructors(classNode, out);
        List methods = classNode.getMethods();
        if (methods != null) {
            Iterator it = methods.iterator();
            while (it.hasNext()) {
                MethodNode methodNode = (MethodNode)it.next();
                this.genMethod(methodNode, out);
            }
        }
    }

    private void getContructors(ClassNode classNode, PrintWriter out) {
        List constrs = classNode.getDeclaredConstructors();
        if (constrs != null) {
            Iterator it = constrs.iterator();
            while (it.hasNext()) {
                ConstructorNode constrNode = (ConstructorNode)it.next();
                this.genConstructor(constrNode, out);
            }
        }
    }

    private void genFields(ClassNode classNode, PrintWriter out) {
        List fields = classNode.getFields();
        if (fields != null) {
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                FieldNode fieldNode = (FieldNode)it.next();
                this.genField(fieldNode, out);
            }
        }
    }

    private void genProps(ClassNode classNode, PrintWriter out) {
        List props = classNode.getProperties();
        if (props != null) {
            Iterator it = props.iterator();
            while (it.hasNext()) {
                PropertyNode propNode = (PropertyNode)it.next();
                this.genProp(propNode, out);
            }
        }
    }

    private void genProp(PropertyNode propNode, PrintWriter out) {
        String name = propNode.getName().substring(0, 1).toUpperCase() + propNode.getName().substring(1);
        String getterName = "get" + name;
        boolean skipGetter = false;
        List getterCandidates = propNode.getField().getOwner().getMethods(getterName);
        if (getterCandidates != null) {
            Iterator it = getterCandidates.iterator();
            while (it.hasNext()) {
                MethodNode method = (MethodNode)it.next();
                if (method.getParameters().length != 0) continue;
                skipGetter = true;
            }
        }
        if (!skipGetter) {
            this.printModifiers(out, propNode.getModifiers());
            out.print(propNode.getType().getName() + " " + getterName + " () { ");
            this.printReturn(out, propNode.getType());
            out.println(" }");
        }
        String setterName = "set" + name;
        boolean skipSetter = false;
        List setterCandidates = propNode.getField().getOwner().getMethods(setterName);
        if (setterCandidates != null) {
            Iterator it = setterCandidates.iterator();
            while (it.hasNext()) {
                MethodNode method = (MethodNode)it.next();
                if (method.getParameters().length != 1) continue;
                skipSetter = true;
            }
        }
        if (!skipSetter) {
            this.printModifiers(out, propNode.getModifiers());
            out.println("void " + setterName + "( " + propNode.getType().getName() + " value) {}");
        }
    }

    private void genField(FieldNode fieldNode, PrintWriter out) {
        this.printModifiers(out, fieldNode.getModifiers());
        out.println(fieldNode.getType().getName() + " " + fieldNode.getName() + ";");
    }

    private ConstructorCallExpression getConstructorCallExpression(ConstructorNode constructorNode) {
        Statement code = constructorNode.getCode();
        if (!(code instanceof BlockStatement)) {
            return null;
        }
        BlockStatement block = (BlockStatement)code;
        List stats = block.getStatements();
        if (stats == null || stats.size() == 0) {
            return null;
        }
        Statement stat = (Statement)stats.get(0);
        if (!(stat instanceof ExpressionStatement)) {
            return null;
        }
        Expression expr = ((ExpressionStatement)stat).getExpression();
        if (!(expr instanceof ConstructorCallExpression)) {
            return null;
        }
        return (ConstructorCallExpression)expr;
    }

    private void genConstructor(ConstructorNode constructorNode, PrintWriter out) {
        out.print("public ");
        out.print(constructorNode.getDeclaringClass().getNameWithoutPackage());
        this.printParams(constructorNode, out);
        ConstructorCallExpression constrCall = this.getConstructorCallExpression(constructorNode);
        if (constrCall == null || !constrCall.isSpecialCall()) {
            out.println(" {}");
        } else {
            out.println(" {");
            if (constrCall.isSuperCall()) {
                out.print("super(");
            } else {
                out.print("this(");
            }
            this.genSpecialContructorArgs(out, constrCall);
            out.println(");");
            out.println("}");
        }
    }

    private void genSpecialContructorArgs(PrintWriter out, ConstructorCallExpression constrCall) {
        Expression arguments = constrCall.getArguments();
        if (arguments instanceof ArgumentListExpression) {
            ArgumentListExpression argumentListExpression = (ArgumentListExpression)arguments;
            List args = argumentListExpression.getExpressions();
            Iterator it = args.iterator();
            while (it.hasNext()) {
                Expression arg = (Expression)it.next();
                if (arg instanceof ConstantExpression) {
                    ConstantExpression constantExpression = (ConstantExpression)arg;
                    Object o = constantExpression.getValue();
                    if (o instanceof String) {
                        out.print("null");
                    } else {
                        out.print(constantExpression.getText());
                    }
                } else {
                    this.printDefaultValue(out, arg.getType().getName());
                }
                if (arg == args.get(args.size() - 1)) continue;
                out.print(", ");
            }
        }
    }

    private void genMethod(MethodNode methodNode, PrintWriter out) {
        if (!methodNode.getDeclaringClass().isInterface()) {
            this.printModifiers(out, methodNode.getModifiers());
        }
        out.print(methodNode.getReturnType().getName() + " " + methodNode.getName());
        this.printParams(methodNode, out);
        if ((methodNode.getModifiers() & 0x400) != 0) {
            out.println(";");
        } else {
            out.print(" { ");
            ClassNode retType = methodNode.getReturnType();
            this.printReturn(out, retType);
            out.println("}");
        }
    }

    private void printReturn(PrintWriter out, ClassNode retType) {
        String retName = retType.getName();
        if (!retName.equals("void")) {
            out.print("return ");
            this.printDefaultValue(out, retName);
            out.print(";");
        }
    }

    private void printDefaultValue(PrintWriter out, String retName) {
        if (retName.equals("int") || retName.equals("byte") || retName.equals("short") || retName.equals("long") || retName.equals("float") || retName.equals("double") || retName.equals("char")) {
            out.print("0");
        } else if (retName.equals("boolean")) {
            out.print("false");
        } else {
            out.print("null");
        }
    }

    private void printParams(MethodNode methodNode, PrintWriter out) {
        out.print("(");
        Parameter[] parameters = methodNode.getParameters();
        if (parameters != null && parameters.length != 0) {
            for (int i = 0; i != parameters.length - 1; ++i) {
                out.print(parameters[i].getType().getName() + " " + parameters[i].getName());
                out.print(", ");
            }
            out.print(parameters[parameters.length - 1].getType().getName() + " " + parameters[parameters.length - 1].getName());
        }
        out.print(")");
    }

    private void printModifiers(PrintWriter out, int modifiers) {
        if ((modifiers & 1) != 0) {
            out.print("public ");
        }
        if ((modifiers & 4) != 0) {
            out.print("protected ");
        }
        if ((modifiers & 2) != 0) {
            out.print("private ");
        }
        if ((modifiers & 8) != 0) {
            out.print("static ");
        }
        if ((modifiers & 0x20) != 0) {
            out.print("synchronized ");
        }
        if ((modifiers & 0x400) != 0) {
            out.print("abstract ");
        }
    }

    private void genImports(ClassNode classNode, PrintWriter out) {
        Object imp;
        HashSet imports = new HashSet();
        ModuleNode moduleNode = classNode.getModule();
        Iterator it = moduleNode.getImportPackages().iterator();
        while (it.hasNext()) {
            imports.add(it.next());
        }
        it = moduleNode.getImports().iterator();
        while (it.hasNext()) {
            imp = (ImportNode)it.next();
            String name = ((ImportNode)imp).getType().getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot == -1) continue;
            imports.add(name.substring(0, lastDot + 1));
        }
        it = imports.iterator();
        while (it.hasNext()) {
            imp = (String)it.next();
            out.println("import " + (String)imp + "*;");
        }
        out.println();
    }

    public void clean() {
        Iterator it = this.toCompile.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            new File(this.outputPath, path + ".java").delete();
        }
    }
}

