/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.mojo.javacc.ToolFacade;
import org.codehaus.plexus.util.FileUtils;

class JJTree
extends ToolFacade {
    private File inputFile;
    private File outputDirectory;
    private String jdkVersion;
    private Boolean isStatic;
    private Boolean buildNodeFiles;
    private Boolean multi;
    private Boolean nodeDefaultVoid;
    private Boolean nodeFactory;
    private String nodePackage;
    private String nodePrefix;
    private Boolean nodeScopeHook;
    private Boolean nodeUsesParser;
    private Boolean visitor;
    private String visitorException;

    JJTree() {
    }

    public void setInputFile(File value) {
        this.inputFile = value;
    }

    public void setOutputDirectory(File value) {
        this.outputDirectory = value;
    }

    public File getOutputFile() {
        File outputFile = null;
        if (this.outputDirectory != null && this.inputFile != null) {
            String fileName = FileUtils.removeExtension((String)this.inputFile.getName()) + ".jj";
            outputFile = new File(this.outputDirectory, fileName);
        }
        return outputFile;
    }

    public void setJdkVersion(String value) {
        this.jdkVersion = value;
    }

    public void setStatic(Boolean value) {
        this.isStatic = value;
    }

    public void setBuildNodeFiles(Boolean value) {
        this.buildNodeFiles = value;
    }

    public void setMulti(Boolean value) {
        this.multi = value;
    }

    public void setNodeDefaultVoid(Boolean value) {
        this.nodeDefaultVoid = value;
    }

    public void setNodeFactory(Boolean value) {
        this.nodeFactory = value;
    }

    public void setNodePackage(String value) {
        this.nodePackage = value;
    }

    public void setNodePrefix(String value) {
        this.nodePrefix = value;
    }

    public void setNodeScopeHook(Boolean value) {
        this.nodeScopeHook = value;
    }

    public void setNodeUsesParser(Boolean value) {
        this.nodeUsesParser = value;
    }

    public void setVisitor(Boolean value) {
        this.visitor = value;
    }

    public void setVisitorException(String value) {
        this.visitorException = value;
    }

    protected int execute() throws Exception {
        String[] args = this.generateArguments();
        if (this.outputDirectory != null && !this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        org.javacc.jjtree.JJTree jjtree = new org.javacc.jjtree.JJTree();
        return jjtree.main(args);
    }

    private String[] generateArguments() {
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.jdkVersion != null) {
            argsList.add("-JDK_VERSION=" + this.jdkVersion);
        }
        if (this.buildNodeFiles != null) {
            argsList.add("-BUILD_NODE_FILES=" + this.buildNodeFiles);
        }
        if (this.multi != null) {
            argsList.add("-MULTI=" + this.multi);
        }
        if (this.nodeDefaultVoid != null) {
            argsList.add("-NODE_DEFAULT_VOID=" + this.nodeDefaultVoid);
        }
        if (this.nodeFactory != null) {
            argsList.add("-NODE_FACTORY=" + this.nodeFactory);
        }
        if (this.nodePackage != null) {
            argsList.add("-NODE_PACKAGE=" + this.nodePackage);
        }
        if (this.nodePrefix != null) {
            argsList.add("-NODE_PREFIX=" + this.nodePrefix);
        }
        if (this.nodeScopeHook != null) {
            argsList.add("-NODE_SCOPE_HOOK=" + this.nodeScopeHook);
        }
        if (this.nodeUsesParser != null) {
            argsList.add("-NODE_USES_PARSER=" + this.nodeUsesParser);
        }
        if (this.isStatic != null) {
            argsList.add("-STATIC=" + this.isStatic);
        }
        if (this.visitor != null) {
            argsList.add("-VISITOR=" + this.visitor);
        }
        if (this.visitorException != null) {
            argsList.add("-VISITOR_EXCEPTION=" + this.visitorException);
        }
        if (this.outputDirectory != null) {
            argsList.add("-OUTPUT_DIRECTORY=" + this.outputDirectory.getAbsolutePath());
        }
        if (this.inputFile != null) {
            argsList.add(this.inputFile.getAbsolutePath());
        }
        return argsList.toArray(new String[argsList.size()]);
    }

    public String toString() {
        return Arrays.asList(this.generateArguments()).toString();
    }
}

