/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class UrlUtils {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String JAR = "jar:";
    private static final String FILE = "file:";
    private static final String JAR_FILE = "jar:file:";

    UrlUtils() {
    }

    public static File getResourceRoot(URL url, String resource) {
        String path = null;
        if (url != null) {
            String spec = url.toExternalForm();
            if (JAR_FILE.regionMatches(true, 0, spec, 0, JAR_FILE.length())) {
                URL jar;
                try {
                    jar = new URL(spec.substring(JAR.length(), spec.lastIndexOf("!/")));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Invalid JAR URL: " + url + ", " + e.getMessage());
                }
                path = UrlUtils.decodeUrl(jar.getPath());
            } else if (FILE.regionMatches(true, 0, spec, 0, FILE.length())) {
                path = UrlUtils.decodeUrl(url.getPath());
                path = path.substring(0, path.length() - resource.length());
            } else {
                throw new IllegalArgumentException("Invalid class path URL: " + url);
            }
        }
        return path != null ? new File(path) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String decodeUrl(String url) {
        String decoded = url;
        if (url == null) return decoded;
        if (url.indexOf(37) < 0) return decoded;
        int n = url.length();
        StringBuffer buffer = new StringBuffer();
        ByteBuffer bytes = ByteBuffer.allocate(n);
        int i = 0;
        while (i < n) {
            block9: {
                if (url.charAt(i) == '%') {
                    Object var8_8;
                    try {
                        try {
                            do {
                                byte octet = (byte)Integer.parseInt(url.substring(i + 1, i + 3), 16);
                                bytes.put(octet);
                                if ((i += 3) >= n) break;
                            } while (url.charAt(i) == '%');
                            var8_8 = null;
                        }
                        catch (RuntimeException e) {
                            var8_8 = null;
                            if (bytes.position() <= 0) break block9;
                            bytes.flip();
                            buffer.append(UTF8.decode(bytes).toString());
                            bytes.clear();
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        if (bytes.position() <= 0) throw throwable;
                        bytes.flip();
                        buffer.append(UTF8.decode(bytes).toString());
                        bytes.clear();
                        throw throwable;
                    }
                    if (bytes.position() <= 0) continue;
                    bytes.flip();
                    buffer.append(UTF8.decode(bytes).toString());
                    bytes.clear();
                    continue;
                }
            }
            buffer.append(url.charAt(i++));
        }
        return buffer.toString();
    }
}

