/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header.transformer;

import org.codehaus.mojo.license.header.transformer.AbstractFileHeaderTransformer;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=FileHeaderTransformer.class, hint="properties")
public class PropertiesFileHeaderTransformer
extends AbstractFileHeaderTransformer {
    public PropertiesFileHeaderTransformer() {
        super("properties", "header transformer with properties file comment style", "###", "###", "# ");
    }

    public String[] getDefaultAcceptedExtensions() {
        return new String[]{"properties", "sh", "py", "rb", "pl", "pm"};
    }

    public String addHeader(String header, String content) {
        String result;
        int endProlog;
        String prolog = null;
        int startProlog = content.indexOf("#!");
        if (startProlog > -1 && (endProlog = content.indexOf(LINE_SEPARATOR)) > -1) {
            prolog = content.substring(0, endProlog + LINE_SEPARATOR.length());
        }
        if (prolog == null) {
            result = super.addHeader(header, content);
        } else {
            content = content.substring(prolog.length());
            result = super.addHeader(prolog + LINE_SEPARATOR + header, content);
        }
        return result;
    }
}

