/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Collection;
import org.dashj.bls.JNI;
import org.dashj.bls.SWIGTYPE_p_bn_t;

public class BigIntegerVector
extends AbstractList<SWIGTYPE_p_bn_t> {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected BigIntegerVector(long cPtr, boolean cMemoryOwn) {
        Preconditions.checkArgument((cPtr != 0L ? 1 : 0) != 0);
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(BigIntegerVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JNI.delete_BigIntegerVec(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public BigIntegerVector(Collection<SWIGTYPE_p_bn_t> e) {
        this.reserve(e.size());
        for (SWIGTYPE_p_bn_t value : e) {
            this.push_back(value);
        }
    }

    public BigIntegerVector() {
        this(JNI.new_BigIntegerVec__SWIG_0(), true);
    }

    public BigIntegerVector(long n) {
        this(JNI.new_BigIntegerVec__SWIG_1(n), true);
    }

    public BigIntegerVector(BigIntegerVector o) {
        this(JNI.new_BigIntegerVec__SWIG_2(BigIntegerVector.getCPtr(o), o), true);
    }

    public long capacity() {
        return JNI.BigIntegerVec_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        JNI.BigIntegerVec_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return JNI.BigIntegerVec_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        JNI.BigIntegerVec_clear(this.swigCPtr, this);
    }

    public void push_back(SWIGTYPE_p_bn_t x) {
        Preconditions.checkNotNull((Object)x);
        JNI.BigIntegerVec_push_back(this.swigCPtr, this, SWIGTYPE_p_bn_t.getCPtr(x));
    }

    @Override
    public SWIGTYPE_p_bn_t get(int i) {
        long cPtr = JNI.BigIntegerVec_get(this.swigCPtr, this, i);
        return cPtr == 0L ? null : new SWIGTYPE_p_bn_t(cPtr, false);
    }

    @Override
    public SWIGTYPE_p_bn_t set(int i, SWIGTYPE_p_bn_t VECTOR_VALUE_IN) {
        Preconditions.checkNotNull((Object)VECTOR_VALUE_IN);
        long cPtr = JNI.BigIntegerVec_set(this.swigCPtr, this, i, SWIGTYPE_p_bn_t.getCPtr(VECTOR_VALUE_IN));
        return cPtr == 0L ? null : new SWIGTYPE_p_bn_t(cPtr, false);
    }

    @Override
    public int size() {
        return JNI.BigIntegerVec_size(this.swigCPtr, this);
    }

    @Override
    public void removeRange(int from, int to) {
        JNI.BigIntegerVec_removeRange(this.swigCPtr, this, from, to);
    }
}

