/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.dashj.bls.BLSObject;
import org.dashj.bls.ChainCode;
import org.dashj.bls.JNI;
import org.dashj.bls.PublicKey;
import org.dashj.bls.Utils;

public class ExtendedPublicKey
extends BLSObject {
    public static final long VERSION = JNI.ExtendedPublicKey_VERSION_get();
    public static final long EXTENDED_PUBLIC_KEY_SIZE = JNI.ExtendedPublicKey_EXTENDED_PUBLIC_KEY_SIZE_get();

    protected ExtendedPublicKey(long cPtr, boolean cMemoryOwn) {
        super(cPtr, cMemoryOwn);
    }

    protected static long getCPtr(ExtendedPublicKey obj) {
        return obj == null ? 0L : obj.cPointer;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        JNI.delete_ExtendedPublicKey(this.cPointer);
    }

    public static ExtendedPublicKey FromBytes(byte[] serialized) {
        Preconditions.checkNotNull((Object)serialized);
        return new ExtendedPublicKey(JNI.ExtendedPublicKey_FromBytes(serialized), true);
    }

    public ExtendedPublicKey PublicChild(long i) {
        boolean hardened = (i & Integer.MIN_VALUE) != 0L;
        Preconditions.checkArgument((!hardened ? 1 : 0) != 0, (Object)"Cannot derive hardened children from public key");
        return new ExtendedPublicKey(JNI.ExtendedPublicKey_PublicChild(this.cPointer, this, i), true);
    }

    public long GetVersion() {
        return JNI.ExtendedPublicKey_GetVersion(this.cPointer, this);
    }

    public short GetDepth() {
        return JNI.ExtendedPublicKey_GetDepth(this.cPointer, this);
    }

    public long GetParentFingerprint() {
        return JNI.ExtendedPublicKey_GetParentFingerprint(this.cPointer, this);
    }

    public long GetChildNumber() {
        return JNI.ExtendedPublicKey_GetChildNumber(this.cPointer, this);
    }

    public ChainCode GetChainCode() {
        return new ChainCode(JNI.ExtendedPublicKey_GetChainCode(this.cPointer, this), true);
    }

    public PublicKey GetPublicKey() {
        return new PublicKey(JNI.ExtendedPublicKey_GetPublicKey(this.cPointer, this), true);
    }

    public void Serialize(byte[] buffer) {
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkArgument(((long)buffer.length >= EXTENDED_PUBLIC_KEY_SIZE ? 1 : 0) != 0);
        JNI.ExtendedPublicKey_Serialize__SWIG_0(this.cPointer, this, buffer);
    }

    public byte[] Serialize() {
        byte[] bytes = new byte[(int)EXTENDED_PUBLIC_KEY_SIZE];
        this.Serialize(bytes);
        return bytes;
    }

    public String toString() {
        return "ExtendedPublicKey(" + Utils.HEX.encode(this.Serialize()) + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ExtendedPublicKey)) {
            return false;
        }
        ExtendedPublicKey epk = (ExtendedPublicKey)obj;
        byte[] theseBytes = new byte[(int)EXTENDED_PUBLIC_KEY_SIZE];
        this.Serialize(theseBytes);
        byte[] bytes = new byte[(int)EXTENDED_PUBLIC_KEY_SIZE];
        epk.Serialize(bytes);
        return Arrays.equals(theseBytes, bytes);
    }
}

