/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Collection;
import org.dashj.bls.InsecureSignature;
import org.dashj.bls.JNI;

public class InsecureSignatureVector
extends AbstractList<InsecureSignature> {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected InsecureSignatureVector(long cPtr, boolean cMemoryOwn) {
        Preconditions.checkArgument((cPtr != 0L ? 1 : 0) != 0);
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(InsecureSignatureVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JNI.delete_InsecureSignatureVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public InsecureSignatureVector(Collection<InsecureSignature> e) {
        this.reserve(e.size());
        for (InsecureSignature value : e) {
            this.push_back(value);
        }
    }

    public InsecureSignatureVector() {
        this(JNI.new_InsecureSignatureVector__SWIG_0(), true);
    }

    public InsecureSignatureVector(InsecureSignatureVector o) {
        this(JNI.new_InsecureSignatureVector__SWIG_2(InsecureSignatureVector.getCPtr(o), o), true);
    }

    public long capacity() {
        return JNI.InsecureSignatureVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        JNI.InsecureSignatureVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return JNI.InsecureSignatureVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        JNI.InsecureSignatureVector_clear(this.swigCPtr, this);
    }

    public void push_back(InsecureSignature x) {
        Preconditions.checkNotNull((Object)x);
        JNI.InsecureSignatureVector_push_back(this.swigCPtr, this, InsecureSignature.getCPtr(x), x);
    }

    @Override
    public InsecureSignature get(int i) {
        return new InsecureSignature(JNI.InsecureSignatureVector_get(this.swigCPtr, this, i), false);
    }

    @Override
    public InsecureSignature set(int i, InsecureSignature VECTOR_VALUE_IN) {
        Preconditions.checkNotNull((Object)VECTOR_VALUE_IN);
        return new InsecureSignature(JNI.InsecureSignatureVector_set(this.swigCPtr, this, i, InsecureSignature.getCPtr(VECTOR_VALUE_IN), VECTOR_VALUE_IN), true);
    }

    @Override
    public int size() {
        return JNI.InsecureSignatureVector_size(this.swigCPtr, this);
    }

    @Override
    public void removeRange(int from, int to) {
        JNI.InsecureSignatureVector_removeRange(this.swigCPtr, this, from, to);
    }
}

