/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Collection;
import org.dashj.bls.BLS;
import org.dashj.bls.JNI;

public class MessageHashVector
extends AbstractList<byte[]> {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MessageHashVector(long cPtr, boolean cMemoryOwn) {
        Preconditions.checkArgument((cPtr != 0L ? 1 : 0) != 0);
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MessageHashVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JNI.delete_ByteArrayVec(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    MessageHashVector(Collection<byte[]> e) {
        this.reserve(e.size());
        for (byte[] value : e) {
            this.push_back(value);
        }
    }

    public MessageHashVector() {
        this(JNI.new_ByteArrayVec__SWIG_0(), true);
    }

    public MessageHashVector(long n) {
        this(JNI.new_ByteArrayVec__SWIG_1(n), true);
    }

    public MessageHashVector(MessageHashVector o) {
        this(JNI.new_ByteArrayVec__SWIG_2(MessageHashVector.getCPtr(o), o), true);
    }

    public long capacity() {
        return JNI.ByteArrayVec_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        JNI.ByteArrayVec_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return JNI.ByteArrayVec_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        JNI.ByteArrayVec_clear(this.swigCPtr, this);
    }

    public void push_back(byte[] x) {
        Preconditions.checkArgument(((long)x.length == BLS.MESSAGE_HASH_LEN ? 1 : 0) != 0);
        JNI.ByteArrayVec_push_back(this.swigCPtr, this, x);
    }

    @Override
    public byte[] get(int i) {
        return JNI.ByteArrayVec_get(this.swigCPtr, this, i);
    }

    @Override
    public byte[] set(int i, byte[] VECTOR_VALUE_IN) {
        Preconditions.checkArgument(((long)VECTOR_VALUE_IN.length == BLS.MESSAGE_HASH_LEN ? 1 : 0) != 0);
        return JNI.ByteArrayVec_set(this.swigCPtr, this, i, VECTOR_VALUE_IN);
    }

    @Override
    public int size() {
        return JNI.ByteArrayVec_size(this.swigCPtr, this);
    }

    @Override
    public void removeRange(int from, int to) {
        JNI.ByteArrayVec_removeRange(this.swigCPtr, this, from, to);
    }
}

