/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.dashj.bls.BLSObject;
import org.dashj.bls.JNI;
import org.dashj.bls.PublicKeyVector;
import org.dashj.bls.SWIGTYPE_p_g1_t;
import org.dashj.bls.Utils;

public class PublicKey
extends BLSObject {
    public static final long PUBLIC_KEY_SIZE = JNI.PublicKey_PUBLIC_KEY_SIZE_get();

    protected PublicKey(long cPtr, boolean cMemoryOwn) {
        super(cPtr, cMemoryOwn);
    }

    @Override
    public synchronized void delete() {
        JNI.delete_PublicKey(this.cPointer);
    }

    public static PublicKey FromBytes(byte[] key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument(((long)key.length == PUBLIC_KEY_SIZE ? 1 : 0) != 0);
        return new PublicKey(JNI.PublicKey_FromBytes(key), true);
    }

    public static PublicKey FromG1(SWIGTYPE_p_g1_t key) {
        return new PublicKey(JNI.PublicKey_FromG1(SWIGTYPE_p_g1_t.getCPtr(key)), true);
    }

    public PublicKey(PublicKey pubKey) {
        this(JNI.new_PublicKey(PublicKey.getCPtr(pubKey), pubKey), true);
    }

    public static PublicKey AggregateInsecure(PublicKeyVector pubKeys) {
        Preconditions.checkNotNull((Object)pubKeys);
        Preconditions.checkArgument((pubKeys.size() > 0 ? 1 : 0) != 0, (Object)"The number of public keys must be at least 1");
        return new PublicKey(JNI.PublicKey_AggregateInsecure(PublicKeyVector.getCPtr(pubKeys), pubKeys), true);
    }

    public static PublicKey Aggregate(PublicKeyVector pubKeys) {
        Preconditions.checkNotNull((Object)pubKeys);
        Preconditions.checkArgument((pubKeys.size() > 0 ? 1 : 0) != 0, (Object)"The number of public keys must be at least 1");
        return new PublicKey(JNI.PublicKey_Aggregate(PublicKeyVector.getCPtr(pubKeys), pubKeys), true);
    }

    public void Serialize(byte[] buffer) {
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkArgument(((long)buffer.length >= PUBLIC_KEY_SIZE ? 1 : 0) != 0);
        JNI.PublicKey_Serialize__SWIG_0(this.cPointer, this, buffer);
    }

    public byte[] Serialize() {
        byte[] bytes = new byte[(int)PUBLIC_KEY_SIZE];
        this.Serialize(bytes);
        return bytes;
    }

    public String toString() {
        return "PublicKey(" + Utils.HEX.encode(this.Serialize()) + ")";
    }

    public long GetFingerprint() {
        return JNI.PublicKey_GetFingerprint(this.cPointer, this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PublicKey)) {
            return false;
        }
        PublicKey publicKey = (PublicKey)obj;
        byte[] theseBytes = new byte[(int)PUBLIC_KEY_SIZE];
        this.Serialize(theseBytes);
        byte[] bytes = new byte[(int)PUBLIC_KEY_SIZE];
        publicKey.Serialize(bytes);
        return Arrays.equals(theseBytes, bytes);
    }
}

