/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Collection;
import org.dashj.bls.JNI;
import org.dashj.bls.PublicKey;

public class PublicKeyVector
extends AbstractList<PublicKey> {
    private transient long cPointer;
    protected transient boolean owner;

    protected PublicKeyVector(long cPtr, boolean cMemoryOwn) {
        Preconditions.checkArgument((cPtr != 0L ? 1 : 0) != 0);
        this.owner = cMemoryOwn;
        this.cPointer = cPtr;
    }

    protected static long getCPtr(PublicKeyVector obj) {
        return obj == null ? 0L : obj.cPointer;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.cPointer != 0L) {
            if (this.owner) {
                this.owner = false;
                JNI.delete_PublicKeyVec(this.cPointer);
            }
            this.cPointer = 0L;
        }
    }

    public PublicKeyVector(Collection<PublicKey> e) {
        this.reserve(e.size());
        for (PublicKey value : e) {
            this.push_back(value);
        }
    }

    public PublicKeyVector() {
        this(JNI.new_PublicKeyVec__SWIG_0(), true);
    }

    public PublicKeyVector(PublicKeyVector o) {
        this(JNI.new_PublicKeyVec__SWIG_2(PublicKeyVector.getCPtr(o), o), true);
    }

    public long capacity() {
        return JNI.PublicKeyVec_capacity(this.cPointer, this);
    }

    public void reserve(long n) {
        JNI.PublicKeyVec_reserve(this.cPointer, this, n);
    }

    @Override
    public boolean isEmpty() {
        return JNI.PublicKeyVec_isEmpty(this.cPointer, this);
    }

    @Override
    public void clear() {
        JNI.PublicKeyVec_clear(this.cPointer, this);
    }

    public void push_back(PublicKey x) {
        Preconditions.checkNotNull((Object)x);
        JNI.PublicKeyVec_push_back(this.cPointer, this, PublicKey.getCPtr(x), x);
    }

    @Override
    public PublicKey get(int i) {
        return new PublicKey(JNI.PublicKeyVec_get(this.cPointer, this, i), false);
    }

    @Override
    public PublicKey set(int i, PublicKey VECTOR_VALUE_IN) {
        Preconditions.checkNotNull((Object)VECTOR_VALUE_IN);
        return new PublicKey(JNI.PublicKeyVec_set(this.cPointer, this, i, PublicKey.getCPtr(VECTOR_VALUE_IN), VECTOR_VALUE_IN), true);
    }

    @Override
    public int size() {
        return JNI.PublicKeyVec_size(this.cPointer, this);
    }

    @Override
    public void removeRange(int from, int to) {
        JNI.PublicKeyVec_removeRange(this.cPointer, this, from, to);
    }
}

