/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.adapter.webserver.tomcat;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.dromara.dynamictp.common.util.ExecutorUtil;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.dromara.dynamictp.core.aware.AwareManager;
import org.dromara.dynamictp.core.aware.RejectHandlerAware;
import org.dromara.dynamictp.core.aware.TaskEnhanceAware;
import org.dromara.dynamictp.core.reject.RejectedInvocationHandler;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatExecutorProxy
extends ThreadPoolExecutor
implements TaskEnhanceAware,
RejectHandlerAware {
    private static final Logger log = LoggerFactory.getLogger(TomcatExecutorProxy.class);
    private List<TaskWrapper> taskWrappers;
    private final String rejectHandlerType;

    public TomcatExecutorProxy(ThreadPoolExecutor executor) {
        super(executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getKeepAliveTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, executor.getQueue(), executor.getThreadFactory());
        this.setThreadRenewalDelay(executor.getThreadRenewalDelay());
        this.allowCoreThreadTimeOut(executor.allowsCoreThreadTimeOut());
        Object handler = this.getRejectedExecutionHandler(executor);
        this.rejectHandlerType = handler.getClass().getSimpleName();
        try {
            this.setRejectedExecutionHandler((ThreadPoolExecutor.RejectedExecutionHandler)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{ThreadPoolExecutor.RejectedExecutionHandler.class}, (InvocationHandler)new RejectedInvocationHandler(handler)));
        }
        catch (Throwable t) {
            try {
                ReflectionUtil.setFieldValue((String)"handler", (Object)((Object)this), (Object)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{RejectedExecutionHandler.class}, (InvocationHandler)new RejectedInvocationHandler(handler)));
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (executor.getQueue() instanceof TaskQueue) {
            ((TaskQueue)executor.getQueue()).setParent((ThreadPoolExecutor)this);
        }
    }

    public void execute(Runnable command) {
        command = this.getEnhancedTask(command);
        AwareManager.execute((Executor)((Object)this), (Runnable)command);
        super.execute(command);
    }

    protected void beforeExecute(Thread t, Runnable r) {
        AwareManager.beforeExecute((Executor)((Object)this), (Thread)t, (Runnable)r);
        super.beforeExecute(t, r);
    }

    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        AwareManager.afterExecute((Executor)((Object)this), (Runnable)r, (Throwable)t);
        ExecutorUtil.tryExecAfterExecute((Runnable)r, (Throwable)t);
    }

    public List<TaskWrapper> getTaskWrappers() {
        return this.taskWrappers;
    }

    public void setTaskWrappers(List<TaskWrapper> taskWrappers) {
        this.taskWrappers = taskWrappers;
    }

    public String getRejectHandlerType() {
        return this.rejectHandlerType;
    }

    private Object getRejectedExecutionHandler(ThreadPoolExecutor executor) {
        return ReflectionUtil.getFieldValue((String)"handler", (Object)executor);
    }
}

