/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.dromara.hutool.core.annotation.AnnotationMapping;
import org.dromara.hutool.core.annotation.AnnotationUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.CharSequenceUtil;

public class GenericAnnotationMapping
implements AnnotationMapping<Annotation> {
    private final Annotation annotation;
    private final boolean isRoot;
    private final Method[] attributes;

    public static GenericAnnotationMapping create(Annotation annotation, boolean isRoot) {
        return new GenericAnnotationMapping(annotation, isRoot);
    }

    GenericAnnotationMapping(Annotation annotation, boolean isRoot) {
        this.annotation = Objects.requireNonNull(annotation);
        this.isRoot = isRoot;
        this.attributes = AnnotationUtil.getAnnotationAttributes(annotation.annotationType());
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public Annotation getResolvedAnnotation() {
        return this.getAnnotation();
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public Method[] getAttributes() {
        return this.attributes;
    }

    @Override
    public <R> R getAttributeValue(String attributeName, Class<R> attributeType) {
        return Stream.of(this.attributes).filter(attribute -> CharSequenceUtil.equals(attribute.getName(), attributeName)).filter(attribute -> ClassUtil.isAssignable(attributeType, attribute.getReturnType())).findFirst().map(method -> MethodUtil.invoke((Object)this.annotation, method, new Object[0])).map(attributeType::cast).orElse(null);
    }

    @Override
    public <R> R getResolvedAttributeValue(String attributeName, Class<R> attributeType) {
        return this.getAttributeValue(attributeName, attributeType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericAnnotationMapping that = (GenericAnnotationMapping)o;
        return this.isRoot == that.isRoot && this.annotation.equals(that.annotation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.annotation, this.isRoot);
    }
}

