/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.cache.file;

import java.io.File;
import org.dromara.hutool.core.cache.Cache;
import org.dromara.hutool.core.cache.file.AbstractFileCache;
import org.dromara.hutool.core.cache.impl.LFUCache;

public class LFUFileCache
extends AbstractFileCache {
    private static final long serialVersionUID = 1L;

    public LFUFileCache(int capacity) {
        this(capacity, capacity / 2, 0L);
    }

    public LFUFileCache(int capacity, int maxFileSize) {
        this(capacity, maxFileSize, 0L);
    }

    public LFUFileCache(int capacity, int maxFileSize, long timeout) {
        super(capacity, maxFileSize, timeout);
    }

    @Override
    protected Cache<File, byte[]> initCache() {
        return new LFUCache<File, byte[]>(this.capacity, this.timeout){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isFull() {
                return LFUFileCache.this.usedSize > this.capacity;
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                LFUFileCache.this.usedSize -= cachedObject.length;
            }
        };
    }
}

