/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.codec.binary;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.codec.binary.Base64Decoder;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class Base64 {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;

    public static byte[] encode(byte[] arr, boolean lineSep) {
        if (arr == null) {
            return null;
        }
        return lineSep ? java.util.Base64.getMimeEncoder().encode(arr) : java.util.Base64.getEncoder().encode(arr);
    }

    public static String encode(CharSequence source) {
        return Base64.encode(source, DEFAULT_CHARSET);
    }

    public static String encodeUrlSafe(CharSequence source) {
        return Base64.encodeUrlSafe(source, DEFAULT_CHARSET);
    }

    public static String encode(CharSequence source, Charset charset) {
        return Base64.encode(ByteUtil.toBytes(source, charset));
    }

    public static String encodeUrlSafe(CharSequence source, Charset charset) {
        return Base64.encodeUrlSafe(ByteUtil.toBytes(source, charset));
    }

    public static String encode(byte[] source) {
        if (source == null) {
            return null;
        }
        return java.util.Base64.getEncoder().encodeToString(source);
    }

    public static String encodeWithoutPadding(byte[] source) {
        if (source == null) {
            return null;
        }
        return java.util.Base64.getEncoder().withoutPadding().encodeToString(source);
    }

    public static String encodeUrlSafe(byte[] source) {
        if (source == null) {
            return null;
        }
        return java.util.Base64.getUrlEncoder().withoutPadding().encodeToString(source);
    }

    public static String encode(InputStream in) {
        if (in == null) {
            return null;
        }
        return Base64.encode(IoUtil.readBytes(in));
    }

    public static String encodeUrlSafe(InputStream in) {
        if (in == null) {
            return null;
        }
        return Base64.encodeUrlSafe(IoUtil.readBytes(in));
    }

    public static String encode(File file) {
        return Base64.encode(FileUtil.readBytes(file));
    }

    public static String encodeUrlSafe(File file) {
        return Base64.encodeUrlSafe(FileUtil.readBytes(file));
    }

    public static String decodeStrGbk(CharSequence source) {
        return Base64.decodeStr(source, CharsetUtil.GBK);
    }

    public static String decodeStr(CharSequence source) {
        return Base64.decodeStr(source, DEFAULT_CHARSET);
    }

    public static String decodeStr(CharSequence source, Charset charset) {
        return StrUtil.str(Base64.decode(source), charset);
    }

    public static File decodeToFile(CharSequence base64, File destFile) {
        return FileUtil.writeBytes(Base64.decode(base64), destFile);
    }

    public static void decodeToStream(CharSequence base64, OutputStream out, boolean isCloseOut) {
        IoUtil.write(out, isCloseOut, Base64.decode(base64));
    }

    public static byte[] decode(CharSequence base64) {
        return Base64.decode(ByteUtil.toBytes(base64, DEFAULT_CHARSET));
    }

    public static byte[] decode(byte[] in) {
        return Base64Decoder.INSTANCE.decode(in);
    }

    public static boolean isTypeBase64(CharSequence base64) {
        if (base64 == null || base64.length() < 2) {
            return false;
        }
        byte[] bytes = ByteUtil.toUtf8Bytes(base64);
        if (bytes.length != base64.length()) {
            return false;
        }
        return Base64.isTypeBase64(bytes);
    }

    public static boolean isTypeBase64(byte[] base64Bytes) {
        if (base64Bytes == null || base64Bytes.length < 3) {
            return false;
        }
        boolean hasPadding = false;
        for (byte base64Byte : base64Bytes) {
            if (hasPadding) {
                if (61 == base64Byte) continue;
                return false;
            }
            if (61 == base64Byte) {
                hasPadding = true;
                continue;
            }
            if (Base64Decoder.INSTANCE.isBase64Code(base64Byte) || Base64.isWhiteSpace(base64Byte)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

