/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.convert.CompositeConverter;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.reflect.TypeUtil;

public class MapConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static MapConverter INSTANCE = new MapConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type keyType = TypeUtil.getTypeArgument(targetType, 0);
        Type valueType = TypeUtil.getTypeArgument(targetType, 1);
        return this.convert(targetType, keyType, valueType, value);
    }

    public Map<?, ?> convert(Type targetType, Type keyType, Type valueType, Object value) throws ConvertException {
        Map<String, Object> map;
        if (value instanceof Map) {
            Type[] typeArguments;
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(targetType) && null != (typeArguments = TypeUtil.getTypeArguments(valueClass)) && 2 == typeArguments.length && Objects.equals(keyType, typeArguments[0]) && Objects.equals(valueType, typeArguments[1])) {
                return (Map)value;
            }
            map = MapUtil.createMap(TypeUtil.getClass(targetType), LinkedHashMap::new);
            this.convertMapToMap(keyType, valueType, (Map)value, map);
        } else if (BeanUtil.isWritableBean(value.getClass())) {
            map = BeanUtil.beanToMap(value, new String[0]);
            map = this.convert(targetType, keyType, valueType, map);
        } else {
            throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
        }
        return map;
    }

    private void convertMapToMap(Type keyType, Type valueType, Map<?, ?> srcMap, Map targetMap) {
        CompositeConverter convert = CompositeConverter.getInstance();
        srcMap.forEach((key, value) -> targetMap.put(TypeUtil.isUnknown(keyType) ? key : convert.convert(keyType, key), TypeUtil.isUnknown(valueType) ? value : convert.convert(valueType, value)));
    }
}

