/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.Clob;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import org.dromara.hutool.core.convert.AbstractConverter;
import org.dromara.hutool.core.convert.impl.stringer.BlobStringer;
import org.dromara.hutool.core.convert.impl.stringer.ClobStringer;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.xml.XmlUtil;
import org.w3c.dom.Node;

public class StringConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private Map<Class<?>, Function<Object, String>> stringer;

    public StringConverter putStringer(Class<?> clazz, Function<Object, String> stringFunction) {
        if (null == this.stringer) {
            this.stringer = new HashMap();
        }
        this.stringer.put(clazz, stringFunction);
        return this;
    }

    @Override
    protected String convertInternal(Class<?> targetClass, Object value) {
        Function<Object, String> stringFunction;
        if (MapUtil.isNotEmpty(this.stringer) && null != (stringFunction = this.stringer.get(targetClass))) {
            return stringFunction.apply(value);
        }
        if (value instanceof TimeZone) {
            return ((TimeZone)value).getID();
        }
        if (value instanceof Node) {
            return XmlUtil.toStr((Node)value);
        }
        if (value instanceof Clob) {
            return ClobStringer.INSTANCE.apply(value);
        }
        if (value instanceof Blob) {
            return BlobStringer.INSTANCE.apply(value);
        }
        if (value instanceof Type) {
            return ((Type)value).getTypeName();
        }
        return this.convertToStr(value);
    }
}

