/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.comparator.CompareUtil;
import org.dromara.hutool.core.date.BetweenFormatter;
import org.dromara.hutool.core.date.CalendarUtil;
import org.dromara.hutool.core.date.DateBetween;
import org.dromara.hutool.core.date.DateException;
import org.dromara.hutool.core.date.DateField;
import org.dromara.hutool.core.date.DatePattern;
import org.dromara.hutool.core.date.DateRange;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.date.DateUnit;
import org.dromara.hutool.core.date.Month;
import org.dromara.hutool.core.date.Quarter;
import org.dromara.hutool.core.date.StopWatch;
import org.dromara.hutool.core.date.TemporalAccessorUtil;
import org.dromara.hutool.core.date.TimeUtil;
import org.dromara.hutool.core.date.Week;
import org.dromara.hutool.core.date.Zodiac;
import org.dromara.hutool.core.date.format.DatePrinter;
import org.dromara.hutool.core.date.format.GlobalCustomFormat;
import org.dromara.hutool.core.date.format.parser.NormalDateParser;
import org.dromara.hutool.core.date.format.parser.PositionDateParser;
import org.dromara.hutool.core.date.format.parser.RegisterDateParser;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;

public class DateUtil
extends CalendarUtil {
    public static DateTime now() {
        return new DateTime();
    }

    public static DateTime today() {
        return new DateTime(DateUtil.beginOfDay(Calendar.getInstance()));
    }

    public static DateTime dateSecond() {
        return DateUtil.beginOfSecond(DateUtil.now());
    }

    public static DateTime date(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return DateUtil.dateNew(date);
    }

    public static DateTime date(XMLGregorianCalendar date) {
        if (date == null) {
            return null;
        }
        return DateUtil.date(date.toGregorianCalendar());
    }

    public static DateTime dateNew(Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime(date);
    }

    public static DateTime date(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        return new DateTime(date, timeZone);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        return new DateTime(temporalAccessor);
    }

    public static long current() {
        return System.currentTimeMillis();
    }

    public static long currentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String formatNow() {
        return DateUtil.formatDateTime(new DateTime());
    }

    public static String formatToday() {
        return DateUtil.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int quarter(Date date) {
        return DateTime.of(date).quarter();
    }

    public static Quarter quarterEnum(Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static Month monthEnum(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfYear(Date date) {
        return DateTime.of(date).dayOfYear();
    }

    public static int dayOfWeek(Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static Week dayOfWeekEnum(Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static boolean isWeekend(Date date) {
        Week week = DateUtil.dayOfWeekEnum(date);
        return Week.SATURDAY == week || Week.SUNDAY == week;
    }

    public static int hour(Date date, boolean is24HourClock) {
        return DateTime.of(date).hour(is24HourClock);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    public static int millisecond(Date date) {
        return DateTime.of(date).millisecond();
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static int thisYear() {
        return DateUtil.year(DateUtil.now());
    }

    public static int thisMonth() {
        return DateUtil.month(DateUtil.now());
    }

    public static Month thisMonthEnum() {
        return DateUtil.monthEnum(DateUtil.now());
    }

    public static int thisWeekOfYear() {
        return DateUtil.weekOfYear(DateUtil.now());
    }

    public static int thisWeekOfMonth() {
        return DateUtil.weekOfMonth(DateUtil.now());
    }

    public static int thisDayOfMonth() {
        return DateUtil.dayOfMonth(DateUtil.now());
    }

    public static int thisDayOfWeek() {
        return DateUtil.dayOfWeek(DateUtil.now());
    }

    public static Week thisDayOfWeekEnum() {
        return DateUtil.dayOfWeekEnum(DateUtil.now());
    }

    public static int thisHour(boolean is24HourClock) {
        return DateUtil.hour(DateUtil.now(), is24HourClock);
    }

    public static int thisMinute() {
        return DateUtil.minute(DateUtil.now());
    }

    public static int thisSecond() {
        return DateUtil.second(DateUtil.now());
    }

    public static int thisMillisecond() {
        return DateUtil.millisecond(DateUtil.now());
    }

    public static String yearAndQuarter(Date date) {
        return DateUtil.yearAndQuarter(DateUtil.calendar(date));
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        return TimeUtil.formatNormal(localDateTime);
    }

    public static String format(LocalDateTime localDateTime, String format) {
        return TimeUtil.format((TemporalAccessor)localDateTime, format);
    }

    public static String format(Date date, String format) {
        if (null == date || StrUtil.isBlank(format)) {
            return null;
        }
        if (GlobalCustomFormat.isCustomFormat(format)) {
            return GlobalCustomFormat.format(date, (CharSequence)format);
        }
        TimeZone timeZone = null;
        if (date instanceof DateTime) {
            timeZone = ((DateTime)date).getTimeZone();
        }
        return DateUtil.format(date, DateUtil.newSimpleFormat(format, null, timeZone));
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateTimeFormatter format) {
        if (null == format || null == date) {
            return null;
        }
        return TemporalAccessorUtil.format((TemporalAccessor)date.toInstant(), format);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_TIME_FORMAT.format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.HTTP_DATETIME_FORMAT.format(date);
    }

    public static String formatChineseDate(Date date, boolean isUppercase, boolean withTime) {
        if (null == date) {
            return null;
        }
        if (!isUppercase) {
            return (withTime ? DatePattern.CHINESE_DATE_TIME_FORMAT : DatePattern.CHINESE_DATE_FORMAT).format(date);
        }
        return CalendarUtil.formatChineseDate(CalendarUtil.calendar(date), withTime);
    }

    public static DateTime parse(CharSequence dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(CharSequence dateStr, PositionDateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(CharSequence dateStr, PositionDateParser parser, boolean lenient) {
        return new DateTime(dateStr, parser, lenient);
    }

    public static DateTime parse(CharSequence dateStr, DateTimeFormatter formatter) {
        return new DateTime(dateStr, formatter);
    }

    public static DateTime parse(CharSequence dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parse(CharSequence dateStr, String format, Locale locale) {
        if (GlobalCustomFormat.isCustomFormat(format)) {
            return new DateTime(GlobalCustomFormat.parse(dateStr, format));
        }
        return new DateTime(dateStr, DateUtil.newSimpleFormat(format, locale, null));
    }

    public static DateTime parse(String str, String ... parsePatterns) throws DateException {
        return DateUtil.date(CalendarUtil.parseByPatterns(str, parsePatterns));
    }

    public static DateTime parse(CharSequence dateCharSequence) {
        if (StrUtil.isBlank(dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        Date result = RegisterDateParser.INSTANCE.parse(dateStr = StrUtil.removeAll((CharSequence)dateStr.trim(), '\u65e5', '\u79d2'));
        if (null != result) {
            return DateUtil.date(result);
        }
        if (NormalDateParser.INSTANCE.test(dateStr = DateUtil.normalize(dateStr))) {
            return NormalDateParser.INSTANCE.parse(dateStr);
        }
        throw new DateException("No format fit for date String [{}] !", dateStr);
    }

    public static DateTime truncate(Date date, DateField dateField) {
        return new DateTime(DateUtil.truncate(DateUtil.calendar(date), dateField));
    }

    public static DateTime round(Date date, DateField dateField) {
        return new DateTime(DateUtil.round(DateUtil.calendar(date), dateField));
    }

    public static DateTime ceiling(Date date, DateField dateField) {
        return new DateTime(DateUtil.ceiling(DateUtil.calendar(date), dateField));
    }

    public static DateTime ceiling(Date date, DateField dateField, boolean truncateMillisecond) {
        return new DateTime(DateUtil.ceiling(DateUtil.calendar(date), dateField, truncateMillisecond));
    }

    public static DateTime beginOfSecond(Date date) {
        return new DateTime(DateUtil.beginOfSecond(DateUtil.calendar(date)));
    }

    public static DateTime endOfSecond(Date date) {
        return new DateTime(DateUtil.endOfSecond(DateUtil.calendar(date)));
    }

    public static DateTime beginOfHour(Date date) {
        return new DateTime(DateUtil.beginOfHour(DateUtil.calendar(date)));
    }

    public static DateTime endOfHour(Date date) {
        return new DateTime(DateUtil.endOfHour(DateUtil.calendar(date)));
    }

    public static DateTime beginOfMinute(Date date) {
        return new DateTime(DateUtil.beginOfMinute(DateUtil.calendar(date)));
    }

    public static DateTime endOfMinute(Date date) {
        return new DateTime(DateUtil.endOfMinute(DateUtil.calendar(date)));
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(DateUtil.beginOfDay(DateUtil.calendar(date)));
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(DateUtil.endOfDay(DateUtil.calendar(date)));
    }

    public static DateTime beginOfWeek(Date date) {
        return new DateTime(DateUtil.beginOfWeek(DateUtil.calendar(date)));
    }

    public static DateTime beginOfWeek(Date date, boolean isMondayAsFirstDay) {
        return new DateTime(DateUtil.beginOfWeek(DateUtil.calendar(date), isMondayAsFirstDay));
    }

    public static DateTime endOfWeek(Date date) {
        return new DateTime(DateUtil.endOfWeek(DateUtil.calendar(date)));
    }

    public static DateTime endOfWeek(Date date, boolean isSundayAsLastDay) {
        return new DateTime(DateUtil.endOfWeek(DateUtil.calendar(date), isSundayAsLastDay));
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(DateUtil.beginOfMonth(DateUtil.calendar(date)));
    }

    public static DateTime endOfMonth(Date date) {
        return new DateTime(DateUtil.endOfMonth(DateUtil.calendar(date)));
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(DateUtil.beginOfQuarter(DateUtil.calendar(date)));
    }

    public static DateTime endOfQuarter(Date date) {
        return new DateTime(DateUtil.endOfQuarter(DateUtil.calendar(date)));
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(DateUtil.beginOfYear(DateUtil.calendar(date)));
    }

    public static DateTime endOfYear(Date date) {
        return new DateTime(DateUtil.endOfYear(DateUtil.calendar(date)));
    }

    public static DateTime yesterday() {
        return DateUtil.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return DateUtil.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return DateUtil.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return DateUtil.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return DateUtil.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return DateUtil.offsetMonth(new DateTime(), 1);
    }

    public static DateTime offsetMillisecond(Date date, int offset) {
        return DateUtil.offset(date, DateField.MILLISECOND, offset);
    }

    public static DateTime offsetSecond(Date date, int offset) {
        return DateUtil.offset(date, DateField.SECOND, offset);
    }

    public static DateTime offsetMinute(Date date, int offset) {
        return DateUtil.offset(date, DateField.MINUTE, offset);
    }

    public static DateTime offsetHour(Date date, int offset) {
        return DateUtil.offset(date, DateField.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return DateUtil.offset(date, DateField.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeek(Date date, int offset) {
        return DateUtil.offset(date, DateField.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return DateUtil.offset(date, DateField.MONTH, offset);
    }

    public static DateTime offset(Date date, DateField dateField, int offset) {
        return DateUtil.dateNew(date).offset(dateField, offset);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        return DateUtil.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit, boolean isAbs) {
        return new DateBetween(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(DateUnit.MS);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateUtil.beginOfDay(beginDate);
            endDate = DateUtil.beginOfDay(endDate);
        }
        return DateUtil.between(beginDate, endDate, DateUnit.DAY);
    }

    public static long betweenWeek(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateUtil.beginOfDay(beginDate);
            endDate = DateUtil.beginOfDay(endDate);
        }
        return DateUtil.between(beginDate, endDate, DateUnit.WEEK);
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenYear(isReset);
    }

    public static String formatBetween(Date beginDate, Date endDate, BetweenFormatter.Level level) {
        return DateUtil.formatBetween(DateUtil.between(beginDate, endDate, DateUnit.MS), level);
    }

    public static String formatBetween(Date beginDate, Date endDate) {
        return DateUtil.formatBetween(DateUtil.between(beginDate, endDate, DateUnit.MS));
    }

    public static String formatBetween(long betweenMs, BetweenFormatter.Level level) {
        return BetweenFormatter.of(betweenMs, level).format();
    }

    public static String formatBetween(long betweenMs) {
        return BetweenFormatter.of(betweenMs, BetweenFormatter.Level.MILLISECOND).format();
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        return DateUtil.isIn(date, beginDate, endDate, true, true);
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate, boolean includeBegin, boolean includeEnd) {
        boolean isIn;
        if (date == null || beginDate == null || endDate == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u53ef\u4e3anull");
        }
        long thisMills = date.getTime();
        long beginMills = beginDate.getTime();
        long endMills = endDate.getTime();
        long rangeMin = Math.min(beginMills, endMills);
        long rangeMax = Math.max(beginMills, endMills);
        boolean bl = isIn = rangeMin < thisMills && thisMills < rangeMax;
        if (!isIn && includeBegin) {
            boolean bl2 = isIn = thisMills == rangeMin;
        }
        if (!isIn && includeEnd) {
            isIn = thisMills == rangeMax;
        }
        return isIn;
    }

    public static boolean isSameTime(Date date1, Date date2) {
        return date1.compareTo(date2) == 0;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtil.isSameDay(DateUtil.calendar(date1), DateUtil.calendar(date2));
    }

    public static boolean isSameWeek(Date date1, Date date2, boolean isMon) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtil.isSameWeek(DateUtil.calendar(date1), DateUtil.calendar(date2), isMon);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtil.isSameMonth(DateUtil.calendar(date1), DateUtil.calendar(date2));
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static StopWatch createStopWatch() {
        return new StopWatch();
    }

    public static StopWatch createStopWatch(String id) {
        return new StopWatch(id);
    }

    public static int ageOfNow(String birthDay) {
        return DateUtil.ageOfNow(DateUtil.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return DateUtil.age(birthDay, DateUtil.now());
    }

    public static boolean isLeapYear(int year) {
        return Year.isLeap(year);
    }

    public static int age(Date birthday, Date dateToCompare) {
        Assert.notNull(birthday, "Birthday can not be null !", new Object[0]);
        if (null == dateToCompare) {
            dateToCompare = DateUtil.now();
        }
        return DateUtil.age(birthday.getTime(), dateToCompare.getTime());
    }

    public static int timeToSecond(String timeStr) {
        if (StrUtil.isEmpty(timeStr)) {
            return 0;
        }
        List<String> hms = SplitUtil.split(timeStr, ":", 3, true, true);
        int lastIndex = hms.size() - 1;
        int result = 0;
        for (int i = lastIndex; i >= 0; --i) {
            result += (int)((double)Integer.parseInt(hms.get(i)) * Math.pow(60.0, lastIndex - i));
        }
        return result;
    }

    public static String secondToTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public static DateRange range(Date start, Date end, DateField unit) {
        return new DateRange(start, end, unit);
    }

    public static List<DateTime> rangeContains(DateRange start, DateRange end) {
        ArrayList<DateTime> startDateTimes = ListUtil.of(start);
        ArrayList<DateTime> endDateTimes = ListUtil.of(end);
        return startDateTimes.stream().filter(endDateTimes::contains).collect(Collectors.toList());
    }

    public static List<DateTime> rangeNotContains(DateRange start, DateRange end) {
        ArrayList<DateTime> startDateTimes = ListUtil.of(start);
        ArrayList<DateTime> endDateTimes = ListUtil.of(end);
        return endDateTimes.stream().filter(item -> !startDateTimes.contains(item)).collect(Collectors.toList());
    }

    public static <T> List<T> rangeFunc(Date start, Date end, DateField unit, Function<Date, T> func) {
        if (start == null || end == null || start.after(end)) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (DateTime date : DateUtil.range(start, end, unit)) {
            list.add(func.apply(date));
        }
        return list;
    }

    public static void rangeConsume(Date start, Date end, DateField unit, Consumer<Date> consumer) {
        if (start == null || end == null || start.after(end)) {
            return;
        }
        DateUtil.range(start, end, unit).forEach(consumer);
    }

    public static List<DateTime> rangeToList(Date start, Date end, DateField unit) {
        return ListUtil.of(DateUtil.range(start, end, unit));
    }

    public static List<DateTime> rangeToList(Date start, Date end, DateField unit, int step) {
        return ListUtil.of(new DateRange(start, end, unit, step));
    }

    public static String getZodiac(int month, int day) {
        return Zodiac.getZodiac(month, day);
    }

    public static String getChineseZodiac(int year) {
        return Zodiac.getChineseZodiac(year);
    }

    public static int compare(Date date1, Date date2) {
        return CompareUtil.compare(date1, date2);
    }

    public static int compare(Date date1, Date date2, String format) {
        if (format != null) {
            if (date1 != null) {
                date1 = DateUtil.parse((CharSequence)DateUtil.format(date1, format), format);
            }
            if (date2 != null) {
                date2 = DateUtil.parse((CharSequence)DateUtil.format(date2, format), format);
            }
        }
        return CompareUtil.compare(date1, date2);
    }

    public static long nanosToMillis(long duration) {
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }

    public static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    public static Instant toInstant(Date date) {
        return null == date ? null : date.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toInstant(temporalAccessor);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return TimeUtil.of(instant);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return TimeUtil.of(date);
    }

    public static int lengthOfYear(int year) {
        return Year.of(year).length();
    }

    public static int lengthOfMonth(int month, boolean isLeapYear) {
        return java.time.Month.of(month).length(isLeapYear);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return DateUtil.newSimpleFormat(pattern, null, null);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        if (null != timeZone) {
            format.setTimeZone(timeZone);
        }
        format.setLenient(false);
        return format;
    }

    public static String getShortName(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
        }
        return unit.name().toLowerCase();
    }

    public static boolean isOverlap(Date realStartTime, Date realEndTime, Date startTime, Date endTime) {
        return realStartTime.compareTo(endTime) <= 0 && startTime.compareTo(realEndTime) <= 0;
    }

    public static boolean isLastDayOfMonth(Date date) {
        return DateUtil.date(date).isLastDayOfMonth();
    }

    public static int getLastDayOfMonth(Date date) {
        return DateUtil.date(date).getLastDayOfMonth();
    }

    private static String normalize(CharSequence dateStr) {
        if (StrUtil.isBlank(dateStr)) {
            return StrUtil.str(dateStr);
        }
        List<String> dateAndTime = SplitUtil.splitTrim(dateStr, " ");
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StrUtil.str(dateStr);
        }
        StringBuilder builder = StrUtil.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StrUtil.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StrUtil.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }
}

