/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.func;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Map;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.func.LambdaUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.map.WeakConcurrentMap;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ReflectUtil;
import org.dromara.hutool.core.reflect.lookup.LookupUtil;
import org.dromara.hutool.core.reflect.method.MethodTypeUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;

public class LambdaFactory {
    private static final Map<MutableEntry<Class<?>, Executable>, Object> CACHE = new WeakConcurrentMap();

    private LambdaFactory() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public static <F> F build(Class<F> functionInterfaceType, Class<?> methodClass, String methodName, Class<?> ... paramTypes) {
        return LambdaFactory.build(functionInterfaceType, MethodUtil.getMethod(methodClass, methodName, paramTypes));
    }

    public static <F> F build(Class<F> functionInterfaceType, Executable executable) {
        Assert.notNull(functionInterfaceType);
        Assert.notNull(executable);
        MutableEntry<Class<F>, Executable> cacheKey = new MutableEntry<Class<F>, Executable>(functionInterfaceType, executable);
        return (F)CACHE.computeIfAbsent(cacheKey, key -> LambdaFactory.doBuildWithoutCache(functionInterfaceType, executable));
    }

    private static <F> F doBuildWithoutCache(Class<F> funcType, Executable executable) {
        ReflectUtil.setAccessible(executable);
        Method invokeMethod = LambdaUtil.getInvokeMethod(funcType);
        try {
            return (F)LambdaFactory.metaFactory(funcType, invokeMethod, executable).getTarget().invoke();
        }
        catch (Throwable e) {
            throw new HutoolException(e);
        }
    }

    private static CallSite metaFactory(Class<?> funcType, Method funcMethod, Executable executable) throws LambdaConversionException {
        MethodHandles.Lookup caller = LookupUtil.lookup(executable.getDeclaringClass());
        String invokeName = funcMethod.getName();
        MethodType invokedType = MethodType.methodType(funcType);
        Class<?>[] paramTypes = funcMethod.getParameterTypes();
        MethodType samMethodType = MethodType.methodType(funcMethod.getReturnType(), paramTypes);
        MethodHandle implMethodHandle = LookupUtil.unreflect(executable);
        if (ClassUtil.isSerializable(funcType)) {
            return LambdaMetafactory.altMetafactory(caller, invokeName, invokedType, samMethodType, implMethodHandle, MethodTypeUtil.methodType(executable), 1);
        }
        return LambdaMetafactory.metafactory(caller, invokeName, invokedType, samMethodType, implMethodHandle, MethodTypeUtil.methodType(executable));
    }
}

