/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public interface Resource {
    public String getName();

    public URL getUrl();

    public long size();

    public InputStream getStream();

    default public boolean isModified() {
        return false;
    }

    default public void writeTo(OutputStream out) throws IORuntimeException {
        try (InputStream in = this.getStream();){
            IoUtil.copy(in, out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    default public BufferedReader getReader(Charset charset) {
        return IoUtil.toReader(this.getStream(), charset);
    }

    default public String readStr(Charset charset) throws IORuntimeException {
        return IoUtil.read(this.getReader(charset));
    }

    default public String readUtf8Str() throws IORuntimeException {
        return this.readStr(CharsetUtil.UTF_8);
    }

    default public byte[] readBytes() throws IORuntimeException {
        return IoUtil.readBytes(this.getStream());
    }
}

