/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.resource;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.collection.iter.EnumerationIter;
import org.dromara.hutool.core.compress.ZipUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.FileResource;
import org.dromara.hutool.core.io.resource.JarResource;
import org.dromara.hutool.core.io.resource.MultiResource;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.net.url.UrlUtil;
import org.dromara.hutool.core.text.AntPathMatcher;
import org.dromara.hutool.core.text.StrUtil;

public class ResourceFinder {
    private final ClassLoader classLoader;
    private final AntPathMatcher pathMatcher;

    public static ResourceFinder of() {
        return ResourceFinder.of(ClassLoaderUtil.getClassLoader());
    }

    public static ResourceFinder of(ClassLoader classLoader) {
        return new ResourceFinder(classLoader);
    }

    public ResourceFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.pathMatcher = new AntPathMatcher();
    }

    public MultiResource find(String locationPattern) {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        MultiResource result = new MultiResource(new Resource[0]);
        for (Resource rootResource : ResourceUtil.getResources(rootDirPath, this.classLoader)) {
            if (rootResource instanceof JarResource) {
                try {
                    result.addAll(this.findInJar((JarResource)rootResource, subPattern));
                    continue;
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
            if (rootResource instanceof FileResource) {
                result.addAll(this.findInDir((FileResource)rootResource, subPattern));
                continue;
            }
            throw new HutoolException("Unsupported resource type: {}", rootResource.getClass().getName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MultiResource findInJar(JarResource rootResource, String subPattern) throws IOException {
        boolean closeJarFile;
        String rootEntryPath;
        JarFile jarFile;
        URL rootDirURL = rootResource.getUrl();
        URLConnection conn = rootDirURL.openConnection();
        if (conn instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)conn;
            UrlUtil.useCachesIfNecessary(jarCon);
            jarFile = jarCon.getJarFile();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
            closeJarFile = !jarCon.getUseCaches();
        } else {
            String urlFile = rootDirURL.getFile();
            try {
                int separatorIndex = urlFile.indexOf("*/");
                if (separatorIndex == -1) {
                    separatorIndex = urlFile.indexOf("!/");
                }
                if (separatorIndex != -1) {
                    String jarFileUrl = urlFile.substring(0, separatorIndex);
                    rootEntryPath = urlFile.substring(separatorIndex + 2);
                    jarFile = ZipUtil.ofJar(jarFileUrl);
                } else {
                    jarFile = new JarFile(urlFile);
                    rootEntryPath = "";
                }
                closeJarFile = true;
            }
            catch (ZipException ex) {
                return new MultiResource(new Resource[0]);
            }
        }
        rootEntryPath = StrUtil.addSuffixIfNot(rootEntryPath, "/");
        MultiResource result = new MultiResource(new Resource[0]);
        try {
            for (JarEntry entry : new EnumerationIter<JarEntry>(jarFile.entries())) {
                String relativePath;
                String entryPath = entry.getName();
                if (!entryPath.startsWith(rootEntryPath) || !this.pathMatcher.match(subPattern, relativePath = entryPath.substring(rootEntryPath.length()))) continue;
                result.add(ResourceUtil.getResource(UrlUtil.getURL(rootDirURL, relativePath)));
            }
            if (!closeJarFile) return result;
        }
        catch (Throwable throwable) {
            if (!closeJarFile) throw throwable;
            IoUtil.closeQuietly(jarFile);
            throw throwable;
        }
        IoUtil.closeQuietly(jarFile);
        return result;
    }

    protected MultiResource findInDir(FileResource resource, String subPattern) {
        MultiResource result = new MultiResource(new Resource[0]);
        File rootDir = resource.getFile();
        if (!(rootDir.exists() && rootDir.isDirectory() && rootDir.canRead())) {
            return result;
        }
        String fullPattern = ResourceFinder.replaceBackSlash(rootDir.getAbsolutePath() + "/" + subPattern);
        FileUtil.walkFiles(rootDir, file -> {
            String currentPath = ResourceFinder.replaceBackSlash(file.getAbsolutePath());
            if (file.isDirectory()) {
                return this.pathMatcher.matchStart(fullPattern, StrUtil.addSuffixIfNot(currentPath, "/"));
            }
            if (this.pathMatcher.match(fullPattern, currentPath)) {
                result.add(new FileResource((File)file));
                return true;
            }
            return false;
        });
        return result;
    }

    protected String determineRootDir(String location) {
        int prefixEnd = location.indexOf(58) + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && this.pathMatcher.isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    private static String replaceBackSlash(String path) {
        return StrUtil.isEmpty(path) ? path : path.replace('\\', '/');
    }
}

