/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.watch.watchers;

import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dromara.hutool.core.io.watch.Watcher;
import org.dromara.hutool.core.lang.Chain;

public class WatcherChain
implements Watcher,
Chain<Watcher, WatcherChain> {
    private final List<Watcher> chain;

    public static WatcherChain of(Watcher ... watchers) {
        return new WatcherChain(watchers);
    }

    public WatcherChain(Watcher ... watchers) {
        this.chain = Arrays.asList(watchers);
    }

    @Override
    public void onCreate(WatchEvent<?> event, WatchKey key) {
        for (Watcher watcher : this.chain) {
            watcher.onCreate(event, key);
        }
    }

    @Override
    public void onModify(WatchEvent<?> event, WatchKey key) {
        for (Watcher watcher : this.chain) {
            watcher.onModify(event, key);
        }
    }

    @Override
    public void onDelete(WatchEvent<?> event, WatchKey key) {
        for (Watcher watcher : this.chain) {
            watcher.onDelete(event, key);
        }
    }

    @Override
    public void onOverflow(WatchEvent<?> event, WatchKey key) {
        for (Watcher watcher : this.chain) {
            watcher.onOverflow(event, key);
        }
    }

    @Override
    public Iterator<Watcher> iterator() {
        return this.chain.iterator();
    }

    @Override
    public WatcherChain addChain(Watcher element) {
        this.chain.add(element);
        return this;
    }
}

