/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.DatagramSocket;
import java.net.HttpCookie;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.iter.EnumerationIter;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.net.Ipv4Util;
import org.dromara.hutool.core.net.UserPassAuthenticator;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.JNDIUtil;
import org.dromara.hutool.core.util.RandomUtil;

public class NetUtil {
    public static final String LOCAL_IP = "127.0.0.1";
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;

    public static String longToIpv4(long longIP) {
        return Ipv4Util.longToIpv4(longIP);
    }

    public static long ipv4ToLong(String strIP) {
        return Ipv4Util.ipv4ToLong(strIP);
    }

    public static boolean isUsableLocalPort(int port) {
        Throwable throwable;
        if (!NetUtil.isValidPort(port)) {
            return false;
        }
        try {
            throwable = null;
            try (ServerSocket ss = new ServerSocket(port);){
                ss.setReuseAddress(true);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ignored) {
            return false;
        }
        try {
            throwable = null;
            try (DatagramSocket ds = new DatagramSocket(port);){
                ds.setReuseAddress(true);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static int getUsableLocalPort() {
        return NetUtil.getUsableLocalPort(1024);
    }

    public static int getUsableLocalPort(int minPort) {
        return NetUtil.getUsableLocalPort(minPort, 65535);
    }

    public static int getUsableLocalPort(int minPort, int maxPort) {
        int maxPortExclude = maxPort + 1;
        for (int i = minPort; i < maxPortExclude; ++i) {
            int randomPort = RandomUtil.randomInt(minPort, maxPortExclude);
            if (!NetUtil.isUsableLocalPort(randomPort)) continue;
            return randomPort;
        }
        throw new HutoolException("Could not find an available port in the range [{}, {}] after {} attempts", minPort, maxPort, maxPort - minPort);
    }

    public static TreeSet<Integer> getUsableLocalPorts(int numRequested, int minPort, int maxPort) {
        TreeSet<Integer> availablePorts = new TreeSet<Integer>();
        int attemptCount = 0;
        while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
            availablePorts.add(NetUtil.getUsableLocalPort(minPort, maxPort));
        }
        if (availablePorts.size() != numRequested) {
            throw new HutoolException("Could not find {} available  ports in the range [{}, {}]", numRequested, minPort, maxPort);
        }
        return availablePorts;
    }

    public static boolean isInnerIP(String ipAddress) {
        return Ipv4Util.isInnerIP(ipAddress);
    }

    public static String toAbsoluteUrl(String absoluteBasePath, String relativePath) {
        try {
            URL absoluteUrl = new URL(absoluteBasePath);
            return new URL(absoluteUrl, relativePath).toString();
        }
        catch (Exception e) {
            throw new HutoolException(e, "To absolute url [{}] base [{}] error!", relativePath, absoluteBasePath);
        }
    }

    public static String hideIpPart(String ip) {
        return StrUtil.builder(ip.length()).append(ip, 0, ip.lastIndexOf(".") + 1).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetUtil.hideIpPart(NetUtil.longToIpv4(ip));
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static NetworkInterface getNetworkInterface(String name) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = networkInterfaces.nextElement();
            if (null == netInterface || !name.equals(netInterface.getName())) continue;
            return netInterface;
        }
        return null;
    }

    public static Collection<NetworkInterface> getNetworkInterfaces() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        return CollUtil.addAll(new ArrayList(), networkInterfaces);
    }

    public static LinkedHashSet<String> localIpv4s() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(t -> t instanceof Inet4Address);
        return NetUtil.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> toIpList(Set<InetAddress> addressList) {
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        for (InetAddress address : addressList) {
            ipSet.add(address.getHostAddress());
        }
        return ipSet;
    }

    public static LinkedHashSet<String> localIps() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(null);
        return NetUtil.toIpList(localAddressList);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Predicate<InetAddress> addressPredicate) {
        return NetUtil.localAddressList(null, addressPredicate);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Predicate<NetworkInterface> networkInterfaceFilter, Predicate<InetAddress> addressPredicate) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new HutoolException(e);
        }
        Assert.notNull(networkInterfaces, () -> new HutoolException("Get network interface error!"));
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterfaceFilter != null && !networkInterfaceFilter.test(networkInterface)) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressPredicate && !addressPredicate.test(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    public static String getLocalhostStrV4() {
        InetAddress localhost = Ipv4Util.getLocalhost();
        if (null != localhost) {
            return localhost.getHostAddress();
        }
        return null;
    }

    public static InetAddress getLocalhostV4() {
        return Ipv4Util.getLocalhost();
    }

    public static String getLocalMacAddressV4() {
        return Ipv4Util.getLocalMacAddress();
    }

    public static InetSocketAddress createAddress(String host, int port) {
        if (StrUtil.isBlank(host)) {
            return new InetSocketAddress(port);
        }
        return new InetSocketAddress(host, port);
    }

    public static void netCat(String host, int port, boolean isBlock, ByteBuffer data) throws IORuntimeException {
        try (SocketChannel channel = SocketChannel.open(NetUtil.createAddress(host, port));){
            channel.configureBlocking(isBlock);
            channel.write(data);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void netCat(String host, int port, byte[] data) throws IORuntimeException {
        OutputStream out = null;
        try (Socket socket = new Socket(host, port);){
            out = socket.getOutputStream();
            out.write(data);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(out);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(out);
    }

    public static boolean isInRange(String ip, String cidr) {
        int maskSplitMarkIndex = cidr.lastIndexOf("/");
        if (maskSplitMarkIndex < 0) {
            throw new IllegalArgumentException("Invalid cidr: " + cidr);
        }
        long mask = -1L << 32 - Integer.parseInt(cidr.substring(maskSplitMarkIndex + 1));
        long cidrIpAddr = NetUtil.ipv4ToLong(cidr.substring(0, maskSplitMarkIndex));
        return (NetUtil.ipv4ToLong(ip) & mask) == (cidrIpAddr & mask);
    }

    public static String idnToASCII(String unicode) {
        return IDN.toASCII(unicode);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && StrUtil.indexOf(ip, ',') > 0) {
            List<String> ips = SplitUtil.splitTrim(ip, ",");
            for (String subIp : ips) {
                if (NetUtil.isUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknown(String checkString) {
        return StrUtil.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static boolean ping(String ip) {
        return NetUtil.ping(ip, 200);
    }

    public static boolean ping(String ip, int timeout) {
        try {
            return InetAddress.getByName(ip).isReachable(timeout);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static List<HttpCookie> parseCookies(String cookieStr) {
        if (StrUtil.isBlank(cookieStr)) {
            return Collections.emptyList();
        }
        return HttpCookie.parse(cookieStr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOpen(InetSocketAddress address, int timeout) {
        try (Socket sc = new Socket();){
            sc.connect(address, timeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setGlobalAuthenticator(String user, char[] pass) {
        NetUtil.setGlobalAuthenticator(new UserPassAuthenticator(user, pass));
    }

    public static void setGlobalAuthenticator(Authenticator authenticator) {
        Authenticator.setDefault(authenticator);
    }

    public static List<String> getDnsInfo(String hostName, String ... attrNames) {
        String uri = StrUtil.addPrefixIfNot(hostName, "dns:");
        Attributes attributes = JNDIUtil.getAttributes(uri, attrNames);
        ArrayList<String> infos = new ArrayList<String>();
        for (Attribute attribute : new EnumerationIter<Attribute>(attributes.getAll())) {
            try {
                infos.add((String)attribute.get());
            }
            catch (NamingException namingException) {}
        }
        return infos;
    }

    public static String getAddressName(InetAddress address) {
        if (null == address) {
            return null;
        }
        String name = address.getHostName();
        if (StrUtil.isEmpty(name)) {
            name = address.getHostAddress();
        }
        return name;
    }
}

