/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.lookup;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import org.dromara.hutool.core.reflect.lookup.LookupFactory;

public class ConstructorLookupFactory
implements LookupFactory {
    private static final int ALLOWED_MODES = 15;
    private final Constructor<MethodHandles.Lookup> lookupConstructor = ConstructorLookupFactory.createLookupConstructor();

    @Override
    public MethodHandles.Lookup lookup(Class<?> callerClass) {
        try {
            return this.lookupConstructor.newInstance(callerClass, 15);
        }
        catch (Exception e) {
            throw new IllegalStateException("no 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
        }
    }

    private static Constructor<MethodHandles.Lookup> createLookupConstructor() {
        Constructor<MethodHandles.Lookup> constructor;
        try {
            constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("There is no 'Lookup(Class, int)' constructor in java.lang.invoke.MethodHandles.", e);
        }
        constructor.setAccessible(true);
        return constructor;
    }
}

