/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.spi;

import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class JdkServiceLoaderUtil {
    public static <T> T loadFirstAvailable(Class<T> clazz) {
        Iterator<T> iterator = JdkServiceLoaderUtil.load(clazz).iterator();
        while (iterator.hasNext()) {
            try {
                return iterator.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
            }
        }
        return null;
    }

    public static <T> T loadFirst(Class<T> clazz) {
        Iterator<T> iterator = JdkServiceLoaderUtil.load(clazz).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> ServiceLoader<T> load(Class<T> clazz) {
        return JdkServiceLoaderUtil.load(clazz, null);
    }

    public static <T> ServiceLoader<T> load(Class<T> clazz, ClassLoader loader) {
        return ServiceLoader.load(clazz, ObjUtil.defaultIfNull(loader, ClassLoaderUtil::getClassLoader));
    }

    public static <T> List<T> loadList(Class<T> clazz) {
        return JdkServiceLoaderUtil.loadList(clazz, null);
    }

    public static <T> List<T> loadList(Class<T> clazz, ClassLoader loader) {
        return ListUtil.of(false, JdkServiceLoaderUtil.load(clazz, loader));
    }
}

