/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.data.id.Pid;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class RuntimeUtil {
    public static String execForStr(String ... cmds) throws IORuntimeException {
        return RuntimeUtil.execForStr(CharsetUtil.systemCharset(), cmds);
    }

    public static String execForStr(Charset charset, String ... cmds) throws IORuntimeException {
        return RuntimeUtil.getResult(RuntimeUtil.exec(cmds), charset);
    }

    public static List<String> execForLines(String ... cmds) throws IORuntimeException {
        return RuntimeUtil.execForLines(CharsetUtil.systemCharset(), cmds);
    }

    public static List<String> execForLines(Charset charset, String ... cmds) throws IORuntimeException {
        return RuntimeUtil.getResultLines(RuntimeUtil.exec(cmds), charset);
    }

    public static Process exec(String ... cmds) {
        Process process;
        try {
            process = new ProcessBuilder(RuntimeUtil.handleCmds(cmds)).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return process;
    }

    public static Process exec(String[] envp, String ... cmds) {
        return RuntimeUtil.exec(envp, null, cmds);
    }

    public static Process exec(String[] envp, File dir, String ... cmds) {
        try {
            return Runtime.getRuntime().exec(RuntimeUtil.handleCmds(cmds), envp, dir);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static List<String> getResultLines(Process process) {
        return RuntimeUtil.getResultLines(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResultLines(Process process, Charset charset) {
        List list;
        InputStream in = null;
        try {
            in = process.getInputStream();
            list = IoUtil.readLines(in, charset, new ArrayList());
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in);
            RuntimeUtil.destroy(process);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
        RuntimeUtil.destroy(process);
        return list;
    }

    public static String getResult(Process process) {
        return RuntimeUtil.getResult(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResult(Process process, Charset charset) {
        String string;
        InputStream in = null;
        try {
            in = process.getInputStream();
            string = IoUtil.read(in, charset);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in);
            RuntimeUtil.destroy(process);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
        RuntimeUtil.destroy(process);
        return string;
    }

    public static String getErrorResult(Process process) {
        return RuntimeUtil.getErrorResult(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorResult(Process process, Charset charset) {
        String string;
        InputStream in = null;
        try {
            in = process.getErrorStream();
            string = IoUtil.read(in, charset);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in);
            RuntimeUtil.destroy(process);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
        RuntimeUtil.destroy(process);
        return string;
    }

    public static void destroy(Process process) {
        if (null != process) {
            process.destroy();
        }
    }

    public static void addShutdownHook(Runnable hook) {
        Runtime.getRuntime().addShutdownHook(hook instanceof Thread ? (Thread)hook : new Thread(hook));
    }

    public static int getProcessorCount() {
        int cpu = Runtime.getRuntime().availableProcessors();
        if (cpu <= 0) {
            cpu = 7;
        }
        return cpu;
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long getUsableMemory() {
        return RuntimeUtil.getMaxMemory() - RuntimeUtil.getTotalMemory() + RuntimeUtil.getFreeMemory();
    }

    public static int getPid() throws HutoolException {
        return Pid.INSTANCE.get();
    }

    private static String[] handleCmds(String ... cmds) {
        if (ArrayUtil.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == cmds.length) {
            String cmd = cmds[0];
            if (StrUtil.isBlank(cmd)) {
                throw new NullPointerException("Command is blank !");
            }
            cmds = RuntimeUtil.cmdSplit(cmd);
        }
        return cmds;
    }

    private static String[] cmdSplit(String cmd) {
        ArrayList<String> cmds = new ArrayList<String>();
        int length = cmd.length();
        Stack<Character> stack = new Stack<Character>();
        boolean inWrap = false;
        StringBuilder cache = new StringBuilder();
        block4: for (int i = 0; i < length; ++i) {
            char c = cmd.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (inWrap) {
                        if (c == ((Character)stack.peek()).charValue()) {
                            stack.pop();
                            inWrap = false;
                        }
                        cache.append(c);
                        continue block4;
                    }
                    stack.push(Character.valueOf(c));
                    cache.append(c);
                    inWrap = true;
                    continue block4;
                }
                case ' ': {
                    if (inWrap) {
                        cache.append(c);
                        continue block4;
                    }
                    cmds.add(cache.toString());
                    cache.setLength(0);
                    continue block4;
                }
                default: {
                    cache.append(c);
                }
            }
        }
        if (cache.length() > 0) {
            cmds.add(cache.toString());
        }
        return cmds.toArray(new String[0]);
    }
}

