/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.xml;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.xml.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlMapper {
    private final Node node;

    public static XmlMapper of(Node node) {
        return new XmlMapper(node);
    }

    public XmlMapper(Node node) {
        this.node = node;
    }

    public <T> T toBean(Class<T> bean) {
        Map<String, Object> map = this.toMap();
        if (null != map && map.size() == 1) {
            String nodeName = CollUtil.getFirst(map.keySet());
            if (bean.getSimpleName().equalsIgnoreCase(nodeName)) {
                return BeanUtil.toBean(CollUtil.get(map.values(), 0), bean);
            }
        }
        return BeanUtil.toBean(map, bean);
    }

    public Map<String, Object> toMap() {
        return this.toMap(new LinkedHashMap<String, Object>());
    }

    public Map<String, Object> toMap(Map<String, Object> result) {
        return XmlMapper.toMap(this.node, result);
    }

    private static Map<String, Object> toMap(Node node, Map<String, Object> result) {
        if (null == result) {
            result = new HashMap<String, Object>();
        }
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Map<String, Object> map;
            Node childNode = nodeList.item(i);
            if (!XmlUtil.isElement(childNode)) continue;
            Element childEle = (Element)childNode;
            Object newValue = childEle.hasChildNodes() ? (MapUtil.isNotEmpty(map = XmlMapper.toMap(childEle, new LinkedHashMap<String, Object>())) ? map : childEle.getTextContent()) : childEle.getTextContent();
            if (null == newValue) continue;
            Object value = result.get(childEle.getNodeName());
            if (null != value) {
                if (value instanceof List) {
                    ((List)value).add(newValue);
                    continue;
                }
                result.put(childEle.getNodeName(), ListUtil.of(value, newValue));
                continue;
            }
            result.put(childEle.getNodeName(), newValue);
        }
        return result;
    }
}

