/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto;

import java.io.File;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.AlphabetMapper;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.codec.binary.Hex;
import org.dromara.hutool.core.lang.Validator;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.SystemUtil;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import org.dromara.hutool.crypto.asymmetric.RSA;
import org.dromara.hutool.crypto.digest.DigestAlgorithm;
import org.dromara.hutool.crypto.digest.Digester;
import org.dromara.hutool.crypto.digest.MD5;
import org.dromara.hutool.crypto.digest.mac.HMac;
import org.dromara.hutool.crypto.digest.mac.HmacAlgorithm;
import org.dromara.hutool.crypto.provider.GlobalProviderFactory;
import org.dromara.hutool.crypto.symmetric.AES;
import org.dromara.hutool.crypto.symmetric.DES;
import org.dromara.hutool.crypto.symmetric.DESede;
import org.dromara.hutool.crypto.symmetric.FPE;
import org.dromara.hutool.crypto.symmetric.PBKDF2;
import org.dromara.hutool.crypto.symmetric.SymmetricAlgorithm;
import org.dromara.hutool.crypto.symmetric.SymmetricCrypto;
import org.dromara.hutool.crypto.symmetric.ZUC;

public class SecureUtil {
    public static String HUTOOL_CRYPTO_DECODE_HEX = "hutool.crypto.decodeHex";

    public static String generateAlgorithm(AsymmetricAlgorithm asymmetricAlgorithm, DigestAlgorithm digestAlgorithm) {
        String digestPart = null == digestAlgorithm ? "NONE" : digestAlgorithm.name();
        return StrUtil.format("{}with{}", digestPart, asymmetricAlgorithm.getValue());
    }

    public static AES aes() {
        return new AES();
    }

    public static AES aes(byte[] key) {
        return new AES(key);
    }

    public static DES des() {
        return new DES();
    }

    public static DES des(byte[] key) {
        return new DES(key);
    }

    public static DESede desede() {
        return new DESede();
    }

    public static DESede desede(byte[] key) {
        return new DESede(key);
    }

    public static MD5 md5() {
        return MD5.of();
    }

    public static String md5(String data) {
        return MD5.of().digestHex(data);
    }

    public static String md5(InputStream data) {
        return MD5.of().digestHex(data);
    }

    public static String md5(File dataFile) {
        return MD5.of().digestHex(dataFile);
    }

    public static Digester sha1() {
        return new Digester(DigestAlgorithm.SHA1);
    }

    public static String sha1(String data) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data);
    }

    public static String sha1(InputStream data) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data);
    }

    public static String sha1(File dataFile) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(dataFile);
    }

    public static Digester sha256() {
        return new Digester(DigestAlgorithm.SHA256);
    }

    public static String sha256(String data) {
        return new Digester(DigestAlgorithm.SHA256).digestHex(data);
    }

    public static String sha256(InputStream data) {
        return new Digester(DigestAlgorithm.SHA256).digestHex(data);
    }

    public static String sha256(File dataFile) {
        return new Digester(DigestAlgorithm.SHA256).digestHex(dataFile);
    }

    public static HMac hmac(HmacAlgorithm algorithm, String key) {
        return new HMac(algorithm, ByteUtil.toUtf8Bytes(key));
    }

    public static HMac hmac(HmacAlgorithm algorithm, byte[] key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmac(HmacAlgorithm algorithm, SecretKey key) {
        return new HMac(algorithm, (Key)key);
    }

    public static HMac hmacMd5(String key) {
        return SecureUtil.hmacMd5(ByteUtil.toUtf8Bytes(key));
    }

    public static HMac hmacMd5(byte[] key) {
        return new HMac(HmacAlgorithm.HmacMD5, key);
    }

    public static HMac hmacMd5() {
        return new HMac(HmacAlgorithm.HmacMD5);
    }

    public static HMac hmacSha1(String key) {
        return SecureUtil.hmacSha1(ByteUtil.toUtf8Bytes(key));
    }

    public static HMac hmacSha1(byte[] key) {
        return new HMac(HmacAlgorithm.HmacSHA1, key);
    }

    public static HMac hmacSha1() {
        return new HMac(HmacAlgorithm.HmacSHA1);
    }

    public static HMac hmacSha256(String key) {
        return SecureUtil.hmacSha256(ByteUtil.toUtf8Bytes(key));
    }

    public static HMac hmacSha256(byte[] key) {
        return new HMac(HmacAlgorithm.HmacSHA256, key);
    }

    public static HMac hmacSha256() {
        return new HMac(HmacAlgorithm.HmacSHA256);
    }

    public static RSA rsa() {
        return new RSA();
    }

    public static RSA rsa(String privateKeyBase64, String publicKeyBase64) {
        return new RSA(privateKeyBase64, publicKeyBase64);
    }

    public static RSA rsa(byte[] privateKey, byte[] publicKey) {
        return new RSA(privateKey, publicKey);
    }

    public static void addProvider(Provider provider) {
        if (ArrayUtil.contains(Security.getProviders(), provider)) {
            return;
        }
        Security.insertProviderAt(provider, 0);
    }

    public static byte[] decode(String key) {
        if (Objects.isNull(key)) {
            return null;
        }
        boolean decodeHex = SystemUtil.getBoolean(HUTOOL_CRYPTO_DECODE_HEX, true);
        return decodeHex && Validator.isHex(key) ? Hex.decode(key) : Base64.decode(key);
    }

    public static Cipher createCipher(String algorithm) {
        Cipher cipher;
        Provider provider = GlobalProviderFactory.getProvider();
        try {
            cipher = null == provider ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return cipher;
    }

    public static MessageDigest createMessageDigest(String algorithm, Provider provider) {
        MessageDigest messageDigest;
        if (null == provider) {
            provider = GlobalProviderFactory.getProvider();
        }
        try {
            messageDigest = null == provider ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return messageDigest;
    }

    public static MessageDigest createJdkMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }

    public static Mac createMac(String algorithm) {
        Mac mac;
        Provider provider = GlobalProviderFactory.getProvider();
        try {
            mac = null == provider ? Mac.getInstance(algorithm) : Mac.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return mac;
    }

    public static SymmetricCrypto rc4(byte[] key) {
        return new SymmetricCrypto(SymmetricAlgorithm.RC4, key);
    }

    public static void disableCustomProvider() {
        GlobalProviderFactory.setUseCustomProvider(false);
    }

    public static String pbkdf2(char[] password, byte[] salt) {
        return new PBKDF2().encryptHex(password, salt);
    }

    public static FPE fpe(FPE.FPEMode mode, byte[] key, AlphabetMapper mapper, byte[] tweak) {
        return new FPE(mode, key, mapper, tweak);
    }

    public static ZUC zuc128(byte[] key, byte[] iv) {
        return new ZUC(ZUC.ZUCAlgorithm.ZUC_128, key, iv);
    }

    public static ZUC zuc256(byte[] key, byte[] iv) {
        return new ZUC(ZUC.ZUCAlgorithm.ZUC_256, key, iv);
    }
}

