/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.SignUtil;
import org.dromara.hutool.crypto.asymmetric.BaseAsymmetric;
import org.dromara.hutool.crypto.asymmetric.SignAlgorithm;

public class Sign
extends BaseAsymmetric<Sign> {
    private static final long serialVersionUID = 1L;
    protected Signature signature;

    public Sign(SignAlgorithm algorithm) {
        this(algorithm, null, (byte[])null);
    }

    public Sign(String algorithm) {
        this(algorithm, null, (byte[])null);
    }

    public Sign(SignAlgorithm algorithm, String privateKeyStr, String publicKeyStr) {
        this(algorithm.getValue(), SecureUtil.decode(privateKeyStr), SecureUtil.decode(publicKeyStr));
    }

    public Sign(SignAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public Sign(SignAlgorithm algorithm, KeyPair keyPair) {
        this(algorithm.getValue(), keyPair);
    }

    public Sign(SignAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public Sign(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm, Base64.decode(privateKeyBase64), Base64.decode(publicKeyBase64));
    }

    public Sign(String algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm, KeyUtil.generatePrivateKey(algorithm, privateKey), KeyUtil.generatePublicKey(algorithm, publicKey));
    }

    public Sign(String algorithm, KeyPair keyPair) {
        this(algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    public Sign(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    @Override
    public Sign init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this.signature = SignUtil.createSignature(algorithm);
        super.init(algorithm, privateKey, publicKey);
        return this;
    }

    public Sign setParameter(AlgorithmParameterSpec params) {
        try {
            this.signature.setParameter(params);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] sign(String data, Charset charset) {
        return this.sign(ByteUtil.toBytes(data, charset));
    }

    public byte[] sign(String data) {
        return this.sign(data, CharsetUtil.UTF_8);
    }

    public String signHex(String data, Charset charset) {
        return HexUtil.encodeStr(this.sign(data, charset));
    }

    public String signHex(String data) {
        return this.signHex(data, CharsetUtil.UTF_8);
    }

    public byte[] sign(byte[] data) {
        return this.sign(new ByteArrayInputStream(data), -1);
    }

    public String signHex(byte[] data) {
        return HexUtil.encodeStr(this.sign(data));
    }

    public String signHex(InputStream data) {
        return HexUtil.encodeStr(this.sign(data));
    }

    public byte[] sign(InputStream data) {
        return this.sign(data, 8192);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtil.encodeStr(this.sign(data, bufferLength));
    }

    public byte[] sign(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        byte[] buffer = new byte[bufferLength];
        this.lock.lock();
        try {
            byte[] result;
            this.signature.initSign(this.privateKey);
            try {
                int read = data.read(buffer, 0, bufferLength);
                while (read > -1) {
                    this.signature.update(buffer, 0, read);
                    read = data.read(buffer, 0, bufferLength);
                }
                result = this.signature.sign();
            }
            catch (Exception e) {
                throw new CryptoException(e);
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        this.lock.lock();
        try {
            this.signature.initVerify(this.publicKey);
            this.signature.update(data);
            boolean bl = this.signature.verify(sign);
            return bl;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Sign setSignature(Signature signature) {
        this.signature = signature;
        return this;
    }

    public Sign setCertificate(Certificate certificate) {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (certificate instanceof X509Certificate && CollUtil.isNotEmpty(critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) && critSet.contains("2.5.29.15") && (keyUsageInfo = cert.getKeyUsage()) != null && !keyUsageInfo[0]) {
            throw new CryptoException("Wrong key usage");
        }
        this.publicKey = certificate.getPublicKey();
        return this;
    }
}

