/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric.paillier;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import org.dromara.hutool.core.util.RandomUtil;
import org.dromara.hutool.crypto.asymmetric.paillier.PaillierPrivateKey;
import org.dromara.hutool.crypto.asymmetric.paillier.PaillierPublicKey;

public class PaillierKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int KEYSIZE_DEFAULT = 64;
    private int certainty = 64;
    private int keySize = 64;
    private SecureRandom random;

    public static PaillierKeyPairGenerator of() {
        return PaillierKeyPairGenerator.of(64);
    }

    public static PaillierKeyPairGenerator of(int keySize) {
        return PaillierKeyPairGenerator.of(keySize, null);
    }

    public static PaillierKeyPairGenerator of(int keySize, SecureRandom random) {
        PaillierKeyPairGenerator generator = new PaillierKeyPairGenerator();
        generator.initialize(keySize, random);
        return generator;
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        this.random = random;
        this.keySize = keySize < 8 || keySize > 3096 ? 64 : keySize;
    }

    public void setCertainty(int certainty) {
        this.certainty = certainty;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (null == this.random) {
            this.random = RandomUtil.getSecureRandom();
        }
        BigInteger p = this.generateP();
        BigInteger q = this.generateQ(p);
        BigInteger n = p.multiply(q);
        BigInteger nsquare = n.multiply(n);
        BigInteger lambda = PaillierKeyPairGenerator.getLambda(p, q);
        BigInteger g = this.generateG(n, nsquare, lambda);
        BigInteger u = PaillierKeyPairGenerator.getU(g, n, nsquare, lambda);
        PaillierPublicKey publicKey = new PaillierPublicKey(n, g);
        PaillierPrivateKey privateKey = new PaillierPrivateKey(n, lambda, u);
        return new KeyPair(publicKey, privateKey);
    }

    private BigInteger generateP() {
        return new BigInteger(this.keySize / 2, this.certainty, this.random);
    }

    private BigInteger generateQ(BigInteger p) {
        BigInteger q;
        while ((q = new BigInteger(this.keySize / 2, this.certainty, this.random)).compareTo(p) == 0) {
        }
        return q;
    }

    private BigInteger generateG(BigInteger n, BigInteger nsquare, BigInteger lambda) {
        BigInteger g;
        while ((g = new BigInteger(this.keySize, 64, this.random)).compareTo(nsquare) >= 0 || g.gcd(nsquare).intValue() != 1 || g.modPow(lambda, nsquare).subtract(BigInteger.ONE).divide(n).gcd(n).intValue() != 1) {
        }
        return g;
    }

    private static BigInteger getLambda(BigInteger p, BigInteger q) {
        return p.subtract(BigInteger.ONE).multiply(q.subtract(BigInteger.ONE)).divide(p.subtract(BigInteger.ONE).gcd(q.subtract(BigInteger.ONE)));
    }

    private static BigInteger getU(BigInteger g, BigInteger n, BigInteger nsquare, BigInteger lambda) {
        return g.modPow(lambda, nsquare).subtract(BigInteger.ONE).divide(n).modInverse(n);
    }
}

