/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.digest.mac;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.digest.mac.MacEngine;

public class JCEMacEngine
extends SimpleWrapper<Mac>
implements MacEngine {
    public JCEMacEngine(String algorithm, byte[] key) {
        this(algorithm, null == key ? null : new SecretKeySpec(key, algorithm));
    }

    public JCEMacEngine(String algorithm, Key key) {
        this(algorithm, key, null);
    }

    public JCEMacEngine(String algorithm, Key key, AlgorithmParameterSpec spec) {
        super(JCEMacEngine.initMac(algorithm, key, spec));
    }

    @Override
    public void update(byte[] in) {
        ((Mac)this.raw).update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        ((Mac)this.raw).update(in, inOff, len);
    }

    @Override
    public byte[] doFinal() {
        return ((Mac)this.raw).doFinal();
    }

    @Override
    public void reset() {
        ((Mac)this.raw).reset();
    }

    @Override
    public int getMacLength() {
        return ((Mac)this.raw).getMacLength();
    }

    @Override
    public String getAlgorithm() {
        return ((Mac)this.raw).getAlgorithm();
    }

    private static Mac initMac(String algorithm, Key key, AlgorithmParameterSpec spec) {
        Mac mac;
        try {
            mac = SecureUtil.createMac(algorithm);
            if (null == key) {
                key = KeyUtil.generateKey(algorithm);
            }
            if (null != spec) {
                mac.init(key, spec);
            } else {
                mac.init(key);
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return mac;
    }
}

