/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.openssl;

import java.security.MessageDigest;
import java.util.Arrays;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.crypto.digest.MD5;

public class OpenSSLSaltParser {
    private final MessageDigest digest;
    private final int keyLength;
    private final int ivLength;
    private String algorithm;

    public static OpenSSLSaltParser ofMd5(int keyLength, String algorithm) {
        return OpenSSLSaltParser.of((MessageDigest)MD5.of().getRaw(), keyLength, algorithm);
    }

    public static OpenSSLSaltParser of(MessageDigest digest, int keyLength, String algorithm) {
        return new OpenSSLSaltParser(digest, keyLength, algorithm);
    }

    public OpenSSLSaltParser(MessageDigest digest, int keyLength, String algorithm) {
        int ivLength = 16;
        if (StrUtil.containsIgnoreCase(algorithm, "des")) {
            ivLength = 8;
        }
        this.digest = digest;
        this.keyLength = keyLength;
        this.ivLength = ivLength;
        this.algorithm = algorithm;
    }

    public OpenSSLSaltParser(MessageDigest digest, int keyLength, int ivLength) {
        this.digest = digest;
        this.keyLength = keyLength;
        this.ivLength = ivLength;
    }

    public byte[][] getKeyAndIV(byte[] pass, byte[] salt) {
        byte[][] keyAndIvResult = new byte[2][];
        if (null == salt) {
            keyAndIvResult[0] = pass;
            return keyAndIvResult;
        }
        Assert.isTrue(8 == salt.length);
        byte[] passAndSalt = ByteUtil.concat(pass, salt);
        byte[] hash = new byte[]{};
        byte[] keyAndIv = new byte[]{};
        for (int i = 0; i < 3 && keyAndIv.length < this.keyLength + this.ivLength; ++i) {
            byte[] hashData = ByteUtil.concat(hash, passAndSalt);
            hash = this.digest.digest(hashData);
            keyAndIv = ByteUtil.concat(keyAndIv, hash);
        }
        keyAndIvResult[0] = Arrays.copyOfRange(keyAndIv, 0, this.keyLength);
        if (!StrUtil.containsAnyIgnoreCase(this.algorithm, "RC", "DES")) {
            keyAndIvResult[1] = Arrays.copyOfRange(keyAndIv, this.keyLength, this.keyLength + this.ivLength);
        }
        return keyAndIvResult;
    }
}

