/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.config;

import java.util.Set;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.io.resource.NoResourceException;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.config.ConfigParser;
import org.dromara.hutool.db.config.DSKeys;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.driver.DriverUtil;
import org.dromara.hutool.db.sql.SqlLog;
import org.dromara.hutool.db.sql.filter.SqlLogFilter;
import org.dromara.hutool.log.level.Level;
import org.dromara.hutool.setting.Setting;
import org.dromara.hutool.setting.props.Props;

public class SettingConfigParser
implements ConfigParser {
    private static final String CONNECTION_PREFIX = "connection.";
    private static final String DEFAULT_DB_SETTING_PATH = "config/db.setting";
    private static final String DEFAULT_DB_SETTING_PATH2 = "db.setting";
    private final Setting setting;

    public static SettingConfigParser of() {
        return SettingConfigParser.of(null);
    }

    public static SettingConfigParser of(Setting setting) {
        return new SettingConfigParser(setting);
    }

    public SettingConfigParser(Setting setting) {
        this.setting = null != setting ? setting : SettingConfigParser.createDefaultSetting();
    }

    @Override
    public DbConfig parse(String group) {
        Setting setting = this.setting;
        Setting subSetting = setting.getSetting(StrUtil.emptyIfNull(group));
        if (MapUtil.isEmpty(subSetting)) {
            throw new DbException("No config for group: [{}]", group);
        }
        subSetting.putIfAbsent("showSql", setting.get("showSql"));
        subSetting.putIfAbsent("formatSql", setting.get("formatSql"));
        subSetting.putIfAbsent("showParams", setting.get("showParams"));
        subSetting.putIfAbsent("sqlLevel", setting.get("sqlLevel"));
        return SettingConfigParser.toDbConfig(subSetting);
    }

    private static Setting createDefaultSetting() {
        Setting setting;
        try {
            setting = new Setting(DEFAULT_DB_SETTING_PATH, true);
        }
        catch (NoResourceException e) {
            try {
                setting = new Setting(DEFAULT_DB_SETTING_PATH2, true);
            }
            catch (NoResourceException e2) {
                throw new NoResourceException("Default db setting [{}] or [{}] in classpath not found !", DEFAULT_DB_SETTING_PATH, DEFAULT_DB_SETTING_PATH2);
            }
        }
        return setting;
    }

    private static DbConfig toDbConfig(Setting setting) {
        String caseInsensitive;
        String url = setting.getAndRemove(DSKeys.KEY_ALIAS_URL);
        if (StrUtil.isBlank(url)) {
            throw new DbException("No JDBC URL!");
        }
        String driver = setting.getAndRemove(DSKeys.KEY_ALIAS_DRIVER);
        if (StrUtil.isBlank(driver)) {
            driver = DriverUtil.identifyDriver(url);
        }
        DbConfig dbConfig = (DbConfig)((DbConfig)((DbConfig)((DbConfig)DbConfig.of().setUrl(url)).setDriver(driver)).setUser(setting.getAndRemove(DSKeys.KEY_ALIAS_USER))).setPass(setting.getAndRemove(DSKeys.KEY_ALIAS_PASSWORD));
        SqlLogFilter sqlLogFilter = SettingConfigParser.getSqlLogFilter(setting);
        if (null != sqlLogFilter) {
            dbConfig.addSqlFilter(sqlLogFilter);
        }
        if (StrUtil.isNotBlank(caseInsensitive = setting.getAndRemove("caseInsensitive"))) {
            dbConfig.setCaseInsensitive(Convert.toBoolean(caseInsensitive));
        }
        for (String key : DSKeys.KEY_CONN_PROPS) {
            String connValue = setting.getAndRemove(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            dbConfig.addConnProps(key, connValue);
        }
        Props connProps = new Props();
        Set<String> keys = setting.keySet();
        for (String key : keys) {
            if (!key.startsWith(CONNECTION_PREFIX)) continue;
            connProps.set(StrUtil.subSuf(key, CONNECTION_PREFIX.length()), setting.remove(key));
        }
        dbConfig.setConnProps(connProps);
        dbConfig.setPoolProps(setting.toProps());
        return dbConfig;
    }

    private static SqlLogFilter getSqlLogFilter(Setting setting) {
        boolean isShowSql = Convert.toBoolean(setting.remove("showSql"), false);
        if (!isShowSql) {
            return null;
        }
        boolean isFormatSql = Convert.toBoolean(setting.remove("formatSql"), false);
        boolean isShowParams = Convert.toBoolean(setting.remove("showParams"), false);
        String sqlLevelStr = setting.remove("sqlLevel");
        if (null != sqlLevelStr) {
            sqlLevelStr = sqlLevelStr.toUpperCase();
        }
        Level level = Convert.toEnum(Level.class, sqlLevelStr, Level.DEBUG);
        SqlLog sqlLog = new SqlLog();
        sqlLog.init(isShowSql, isFormatSql, isShowParams, level);
        return new SqlLogFilter(sqlLog);
    }
}

