/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.pooled;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.pool.Poolable;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.ds.pooled.ConnectionWrapper;
import org.dromara.hutool.db.ds.pooled.PooledDataSource;
import org.dromara.hutool.setting.props.Props;

public class PooledConnection
extends ConnectionWrapper
implements Poolable<Connection> {
    private final PooledDataSource dataSource;
    private long lastBorrow = System.currentTimeMillis();
    private boolean isClosed = false;

    public PooledConnection(ConnectionConfig<?> config, PooledDataSource dataSource) {
        Properties connProps;
        String password;
        Props info = new Props();
        String user = config.getUser();
        if (user != null) {
            info.setProperty("user", user);
        }
        if ((password = config.getPass()) != null) {
            info.setProperty("password", password);
        }
        if (MapUtil.isNotEmpty(connProps = config.getConnProps())) {
            info.putAll((Map<?, ?>)connProps);
        }
        try {
            this.raw = DriverManager.getConnection(config.getUrl(), info);
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
        this.dataSource = dataSource;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.dataSource.returnObject(this);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public long getLastBorrow() {
        return this.lastBorrow;
    }

    @Override
    public void setLastBorrow(long lastBorrow) {
        this.lastBorrow = lastBorrow;
    }
}

