/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.util.Collection;
import java.util.Set;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.Page;
import org.dromara.hutool.db.sql.Condition;
import org.dromara.hutool.db.sql.SqlUtil;

public class Query
implements Cloneable {
    Collection<String> fields;
    String[] tableNames;
    Condition[] where;
    Page page;

    public static Query of(Entity where) {
        Query query = new Query(SqlUtil.buildConditions(where), where.getTableName());
        Set<String> fieldNames = where.getFieldNames();
        if (CollUtil.isNotEmpty(fieldNames)) {
            query.setFields(fieldNames);
        }
        return query;
    }

    public Query(String ... tableNames) {
        this((Condition[])null, tableNames);
        this.tableNames = tableNames;
    }

    public Query(Condition[] where, String ... tableNames) {
        this(where, (Page)null, tableNames);
    }

    public Query(Condition[] where, Page page, String ... tableNames) {
        this(null, tableNames, where, page);
    }

    public Query(Collection<String> fields, String[] tableNames, Condition[] where, Page page) {
        this.fields = fields;
        this.tableNames = tableNames;
        this.where = where;
        this.page = page;
    }

    public Collection<String> getFields() {
        return this.fields;
    }

    public Query setFields(Collection<String> fields) {
        this.fields = fields;
        return this;
    }

    public Query setFields(String ... fields) {
        this.fields = ListUtil.of(fields);
        return this;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public Query setTableNames(String ... tableNames) {
        this.tableNames = tableNames;
        return this;
    }

    public Condition[] getWhere() {
        return this.where;
    }

    public Query setWhere(Condition ... where) {
        this.where = where;
        return this;
    }

    public Page getPage() {
        return this.page;
    }

    public Query setPage(Page page) {
        this.page = page;
        return this;
    }

    public String getFirstTableName() throws DbException {
        if (ArrayUtil.isEmpty(this.tableNames)) {
            throw new DbException("No tableName!");
        }
        return this.tableNames[0];
    }

    public Query clone() {
        try {
            return (Query)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

