/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.dromara.hutool.core.array.ArrayUtil;

public class CustomProtocolsSSLFactory
extends SSLSocketFactory {
    private final SSLSocketFactory raw;
    private final String[] protocols;

    public CustomProtocolsSSLFactory(SSLSocketFactory factory, String ... protocols) {
        this.raw = factory;
        this.protocols = protocols;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.raw.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.raw.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.raw.createSocket();
        this.resetProtocols(sslSocket);
        return sslSocket;
    }

    @Override
    public SSLSocket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket socket = (SSLSocket)this.raw.createSocket(s, host, port, autoClose);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.raw.createSocket(host, port);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.raw.createSocket(host, port, localHost, localPort);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.raw.createSocket(host, port);
        this.resetProtocols(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.raw.createSocket(address, port, localAddress, localPort);
        this.resetProtocols(socket);
        return socket;
    }

    private void resetProtocols(SSLSocket socket) {
        if (ArrayUtil.isNotEmpty(this.protocols)) {
            socket.setEnabledProtocols(this.protocols);
        }
    }
}

