/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.dromara.hutool.core.bean.path.BeanPath;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.convert.JSONConverter;

public interface JSON
extends Converter,
Cloneable,
Serializable {
    public JSONConfig config();

    public int size();

    default public Object getByPath(String expression) {
        return BeanPath.of(expression).getValue(this);
    }

    default public void putByPath(String expression, Object value) {
        BeanPath.of(expression).setValue(this, value);
    }

    default public <T> T getByPath(String expression, Type resultType) {
        return (T)this.config().getConverter().convert(resultType, this.getByPath(expression));
    }

    default public String toStringPretty() throws JSONException {
        return this.toJSONString(4);
    }

    default public String toJSONString(int indentFactor) throws JSONException {
        StringWriter sw = new StringWriter();
        return this.write(sw, indentFactor, 0, null).toString();
    }

    default public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0, null);
    }

    public Writer write(Writer var1, int var2, int var3, Predicate<MutableEntry<Object, Object>> var4) throws JSONException;

    default public <T> T toBean(Type type) {
        return (T)this.convert(type, this);
    }

    @Override
    default public Object convert(Type targetType, Object value) throws ConvertException {
        return JSONConverter.of(this.config()).convert(targetType, value);
    }
}

