/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.mapper;

import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.function.Predicate;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.mutable.Mutable;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONParser;
import org.dromara.hutool.json.JSONTokener;
import org.dromara.hutool.json.serialize.GlobalSerializeMapping;
import org.dromara.hutool.json.serialize.JSONSerializer;

public class JSONArrayMapper {
    private final Object source;
    private final Predicate<Mutable<Object>> predicate;

    public static JSONArrayMapper of(Object source, Predicate<Mutable<Object>> predicate) {
        return new JSONArrayMapper(source, predicate);
    }

    public JSONArrayMapper(Object source, Predicate<Mutable<Object>> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    public void mapTo(JSONArray jsonArray) throws JSONException {
        Object source = this.source;
        if (null == source) {
            return;
        }
        JSONSerializer<JSON, ?> serializer = GlobalSerializeMapping.getSerializer(source.getClass());
        if (null != serializer) {
            serializer.serialize(jsonArray, source);
            return;
        }
        if (source instanceof JSONTokener) {
            this.mapFromTokener((JSONTokener)source, jsonArray);
        } else if (source instanceof CharSequence) {
            this.mapFromStr((CharSequence)source, jsonArray);
        } else if (source instanceof Reader) {
            this.mapFromTokener(new JSONTokener((Reader)source, jsonArray.config()), jsonArray);
        } else if (source instanceof InputStream) {
            this.mapFromTokener(new JSONTokener((InputStream)source, jsonArray.config()), jsonArray);
        } else if (source instanceof byte[]) {
            byte[] bytesSource = (byte[])source;
            if (91 == bytesSource[0] && 93 == bytesSource[bytesSource.length - 1]) {
                this.mapFromTokener(new JSONTokener(IoUtil.toStream(bytesSource), jsonArray.config()), jsonArray);
            } else {
                for (byte b : bytesSource) {
                    jsonArray.add((Object)b);
                }
            }
        } else {
            Iterator<Object> iter;
            if (ArrayUtil.isArray(source)) {
                iter = new ArrayIter(source);
            } else if (source instanceof Iterator) {
                iter = (Iterator)source;
            } else if (source instanceof Iterable) {
                iter = ((Iterable)source).iterator();
            } else {
                if (!jsonArray.config().isIgnoreError()) {
                    throw new JSONException("JSONArray initial value should be a string or collection or array.");
                }
                return;
            }
            while (iter.hasNext()) {
                Object next = iter.next();
                if (next == source) continue;
                jsonArray.add(next, this.predicate);
            }
        }
    }

    private void mapFromStr(CharSequence source, JSONArray jsonArray) {
        if (null != source) {
            this.mapFromTokener(new JSONTokener(StrUtil.trim(source), jsonArray.config()), jsonArray);
        }
    }

    private void mapFromTokener(JSONTokener x, JSONArray jsonArray) {
        JSONParser.of(x).parseTo(jsonArray, this.predicate);
    }
}

